library(testthat)

test_that("editmatrix works correcly with character",{
   cond <- c( "x == y"
            , "z + w == y + x"
			, "x + z == y + 2*w"
			)
			
   mat <- editmatrix(editrules=cond)
   expect_equal(as.integer(mat[1,]), c(1,-1,0,0))
   expect_equal(as.integer(mat[2,]), c(-1,-1,1,1))
   expect_equal(as.integer(mat[3,]), c(1,-1,1,-2))
})

test_that("editmatrix works correcly with data.frame",{
   
   edtinf.csv <- 
"name,edit
A,x == y
B,z + w == y + x
C,z == y + 2*w
"
   edtinf <- read.csv(textConnection(edtinf.csv))
			
   mat <- editmatrix(edtinf)
   expect_equal(as.integer(mat[1,]), c(1,-1,0,0))
   expect_equal(as.integer(mat[2,]), c(-1,-1,1,1))
   expect_equal(as.integer(mat[3,]), c(0,-1,1,-2))
})

test_that("editmatrix works with constants",{
   cond <- c( "x + y > 2"
            , "y < 10"
            )
   mat <- editmatrix(editrules=cond)
   expect_equal(as.integer(mat[1,]), c(-1,-1,2))
   expect_equal(as.integer(mat[2,]), c(0,1,-10))
})

test_that("is.editmatrix works",{
   mat <- editmatrix(editrules="x==y")
   expect_true(is.editmatrix(mat))
   expect_false(is.editmatrix(unclass(mat)))
})

test_that("editrules returns attribute",{
   mat <- editmatrix(editrules="x==y")
   expect_equal(editrules(mat), attr(mat, "editrules"))
})

test_that("editrules can derive the correct info from a matrix",{
   mat <- matrix( c( 1,-2, 0
                   , 2, 0, 1
				   )
				, nrow=2
				, byrow=TRUE
	#			, dimnames=list(c("a", "b"), c("x","y", "z"))
				)
   ei <- editrules(mat)
   expect_equal(ei$edit, c("a == 2*b", "2*a + c == 0"))
   
   mat <- matrix( c( 1,-2, 0
                   , 2, 0, 1
		 		       )
				    , nrow=2
				    , byrow=TRUE
                , dimnames=list(c("A", "B"), c("x","y", "CONSTANT"))
				)
   ei <- editrules(mat)
   expect_equal(ei$name, c("A","B"))
   expect_equal(ei$edit, c("x == 2*y", "2*x + 1 == 0"))
})