% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{takeout}
\alias{takeout}
\title{Create a named experimental design}
\usage{
takeout(recipe = NULL, show = TRUE)
}
\arguments{
\item{recipe}{A named design object. This should be typically generated from a
function with prefix \code{menu_}. If nothing is supplied, it will randomly select one.}

\item{show}{A logical value to indicate whether the code should be shown or not.
Default is TRUE.}
}
\value{
A recipe design.
}
\description{
This function generates a named experimental
design by supplying the selected menu named design and prints out by default

You can find the available recipes with \code{scan_menu()}.
}
\examples{
takeout(menu_crd(n = 50, t = 5))
# if you omit the design parameters then it will use the default
# (which may be random)
takeout(menu_crd())
# if you don't give any short names then it will generate a random one
takeout()
}
\seealso{
See \code{\link[=scan_menu]{scan_menu()}} for finding the short names of the
named experimental designs.
}
