% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\alias{redesign}
\title{Start the edibble design}
\usage{
design(
  .title = NULL,
  ...,
  .name = "edibble",
  .record = TRUE,
  .seed = NULL,
  .provenance = Provenance$new()
)

redesign(
  .data,
  .title,
  ...,
  .name = NULL,
  .record = TRUE,
  .seed = NULL,
  .provenance = Provenance$new()
)
}
\arguments{
\item{.title}{Optional title of the experiment.}

\item{...}{A series of name-value pairs where the name corresponds to the
name of the metadata nad the value corresponds to the actual metadata value.
If the name is omitted, then no name to the metadata is assigned for the
corresponding value.}

\item{.name}{Optional name of the experiment.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}

\item{.seed}{A seed number for reproducibility.}

\item{.provenance}{An environment setup in a manner to store methods and
information to trace the origin of the design}

\item{.data}{An edibble table.}
}
\value{
An empty \code{edbl_design} object.
}
\description{
This function doesn't really do much besides create a new edibble design object.
}
\examples{
design("My design")
}
\seealso{
Add variables to this design with \code{\link[=set_units]{set_units()}}, \code{\link[=set_trts]{set_trts()}}, and
\code{\link[=set_rcrds]{set_rcrds()}}.

Other user-facing functions: 
\code{\link{allot_trts}()},
\code{\link{allot_units}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
