% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_endpoints_conditions.R
\name{filter_endpoints_conditions}
\alias{filter_endpoints_conditions}
\title{Filter: Start and end conditions}
\usage{
filter_endpoints_conditions(
  eventlog,
  start_condition,
  end_condition,
  reverse,
  ...
)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{start_condition}{A logical condition}

\item{end_condition}{A logical condition}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters cases where the first and/or last activity adhere to the specified conditions
}
\details{
The filter_endpoints method filters cases based on the first and last activity label. It can be used in two ways: by specifying vectors with allowed start
activities and/or allowed end activities, or by specifying a percentile. In the latter case, the percentile value will be used as a cut off.
For example, when set to 0.9, it will select the most common endpoint pairs which together cover at least 90% of the cases, and filter the event log accordingly.
}
\seealso{
\code{vignette("filters", "edeaR")}
}
