% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_lifecycle_presence.R
\name{filter_lifecycle_presence}
\alias{filter_lifecycle_presence}
\alias{filter_lifecycle_presence.eventlog}
\alias{filter_lifecycle_presence.grouped_eventlog}
\alias{ifilter_lifecycle_presence}
\title{Filter: Life cycle Presence}
\usage{
filter_lifecycle_presence(eventlog, lifecycle, method, reverse)

\method{filter_lifecycle_presence}{eventlog}(eventlog, lifecycle = NULL,
  method = c("all", "one_of", "none", "exact", "only"),
  reverse = FALSE)

\method{filter_lifecycle_presence}{grouped_eventlog}(eventlog,
  lifecycle = NULL, method = c("all", "one_of", "none", "exact",
  "only"), reverse = FALSE)

ifilter_lifecycle_presence(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{lifecycle}{Character vector containing one or more life cycle identifiers.}

\item{method}{Filter method. If "all", each of the life cycle labels should be present. If "one_of", at least one of them should be present. If "none", none of the life cycle labels are allowed to occur in the filtered activity instances.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters activity instances based on the presence (or absence) of life cycles
}
\details{
This functions allows to filter activity instances that (do not) contain certain life cycle identifiers.
It requires as input a vector containing one or more life cycle labels and it has a method
argument. The latter can have the values all, none or one_of.
\itemize{
\item When set to `all`, it means
that all the specified life cycle labels must be present for an activity instance to be selected
\item `none` means that they are not allowed to be present.
\item `one_of` means that at least one of them must be present.
\item `only` means that only (a set of) these life cycle labels are allowed to be present
\item `exact` means that only exactly these life cycle labels can be present (although multiple times and in random orderings)
}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log on presence of life cycle labels.

\item \code{grouped_eventlog}: Filter grouped event log on presence of life cycle labels.
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
