% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_trace_frequency.R
\name{filter_trace_frequency}
\alias{filter_trace_frequency}
\alias{ifilter_trace_frequency}
\title{Filter: Trace frequency percentile}
\usage{
filter_trace_frequency(eventlog, lower_threshold = NULL,
  upper_threshold = NULL, percentile_cut_off = NULL, reverse = F)

ifilter_trace_frequency(eventlog)
}
\arguments{
\item{eventlog}{The event log to be used. An object of class
\code{eventlog}.}

\item{lower_threshold}{The lower frequency threshold.
When \code{reverse} is FALSE, all traces with a lower frequency are discarded.}

\item{upper_threshold}{The upper frequency threshold.
When \code{reverse} is FALSE, all traces with a higher frequency are discarded.}

\item{percentile_cut_off}{Alternatively to providing thresholds, a percentile cut off can be provided.
A percentile cut off value of 0.9 will return the most common traces, accounting for 90\% of the cases.
When \code{reverse} is set to TRUE, it will return the least common traces, acoounting for 10\% of the cases.}

\item{reverse}{A logical parameter depicting whether the selection should be reversed.}
}
\description{
Filters the log based the frequency of traces, using an upper and lower threshold or a percentile cut off.
}
