% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr.R
\name{cgr}
\alias{cgr}
\title{Fitting Gaussian copula graphical lasso to co-occurrence data}
\usage{
cgr(
  obj,
  lambda = NULL,
  n.lambda = 100,
  n.samp = 500,
  method = "BIC",
  seed = NULL
)
}
\arguments{
\item{obj}{object of either class \code{\link[mvabund]{manyglm}}, 
or  \code{\link[mvabund]{manyany}} with ordinal models \code{\link[ordinal]{clm}}}

\item{lambda}{vector, values of shrinkage parameter lambda for model 
selection (optional, see detail)}

\item{n.lambda}{integer, number of lambda values 
for model selection (default = 100), ignored if lambda supplied}

\item{n.samp}{integer (default = 500), number of sets residuals used for importance sampling 
(optional, see detail)}

\item{method}{method for selecting shrinkage parameter lambda, either "BIC" (default) or "AIC"}

\item{seed}{integer (default = 1), seed for random number generation (optional, see detail)}
}
\value{
Three objects are returned; 
\code{best_graph} is a list with parameters for the 'best' graphical model, chosen by the chosen \code{method}; 
\code{all_graphs} is a list with likelihood, BIC and AIC for all models along lambda path; 
\code{obj} is the input object.
}
\description{
\code{cgr} is used to fit a Gaussian copula graphical model to 
multivariate discrete data, like species co-occurrence data in ecology. 
This function fits the model and estimates the shrinkage parameter
using BIC. Use \code{\link{plot.cgr}} to plot the resulting graph.
}
\section{Details}{

\code{cgr} is used to fit a Gaussian copula graphical model to multivariate discrete data, such as co-occurrence (multi species) data in ecology. The model is estimated using importance sampling with \code{n.samp} sets of randomised quantile or "Dunn-Smyth" residuals (Dunn & Smyth 1996), and the \code{\link{glasso}} package for fitting Gaussian graphical models. Models are fit for a path of values of the shrinkage parameter \code{lambda} chosen so that both completely dense and sparse models are fit. The \code{lambda} value for the \code{best_graph} is chosen by BIC (default) or AIC.  The seed is controlled so that models with the same data and different predictors can be compared.
}

\section{Author(s)}{

Gordana Popovic <g.popovic@unsw.edu.au>.
}

\section{References}{

Dunn, P.K., & Smyth, G.K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics 5, 236-244.

Popovic, G. C., Hui, F. K., & Warton, D. I. (2018). A general algorithm for covariance modeling of discrete data. Journal of Multivariate Analysis, 165, 86-100.
}

\section{See also}{

\code{\link{plot.cgr}}
}

\examples{
X <- as.data.frame(spider$x)
abund <- spider$abund[,1:5]
spider_mod <- stackedsdm(abund,~1, data = X, ncores=2) 
spid_graph=cgr(spider_mod)
plot(spid_graph,pad=1)
}
