% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-base.R
\name{plot.forecast_esn}
\alias{plot.forecast_esn}
\title{Plot forecasts of a trained ESN model}
\usage{
\method{plot}{forecast_esn}(x, test = NULL, fitted = TRUE, interval = TRUE, n_obs = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{forecast_esn}. The result of a call to \code{forecast_esn()}.}

\item{test}{Numeric vector. Test data, i.e., out-of-sample actual values.}

\item{fitted}{Logical value. If \code{TRUE}, fitted values are added.}

\item{interval}{Logical value. If \code{TRUE}, forecast intervals are added.}

\item{n_obs}{Integer value. If \code{NULL}, all in-sample values are shown, otherwise only the last \code{n_obs}.}

\item{...}{Currently not in use.}
}
\value{
Line chart of point forecast and actual values.
}
\description{
Plot point forecasts and forecast intervals, actual values of a 
  trained ESN model. Optionally, test data (out-of-sample) and fitted values
  can be added to the plot.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
xfcst <- forecast_esn(xmodel, n_ahead = 12)
plot(xfcst)

}
