% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesting.R
\name{nesting}
\alias{nesting}
\alias{e_add}
\alias{e_add_nested}
\alias{e_add_unnested}
\title{Add nested data}
\usage{
e_add(e, param, ..., .serie = NULL, .data = NULL)

e_add_nested(e, param, ..., .serie = NULL, .data = NULL)

e_add_unnested(e, param, value, .serie = NULL, .data = NULL)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{param}{The nested parameter to add data to.}

\item{...}{Any other option to pass, check See Also section.}

\item{.serie}{Serie's index to add the data to, if
`NULL` then it is added to all.}

\item{.data}{A dataset to use, if none are specified than
the original dataset passed to `e_charts` is used.}

\item{value}{The column to map to the parameter.}
}
\description{
Utility function to add data where the original JavaScript library expects nested data.
}
\details{
For instance, \code{\link{e_funnel}} lets you pass \code{values} and \code{labels}
(from your initial data.frame) which corresponds to \code{name} and \code{value} in the
\href{https://echarts.apache.org/en/option.html#series-heatmap.data}{original library}.
However the latter also takes, \code{label}, \code{itemStyle}, and \code{emphasis} but being JSON arrays
they translate to lists in R and dealing with nested data.frames is not ideal. \code{e_add} remedies to that.
It allows adding those nested data points, see the examples below.
}
\section{Functions}{


- `e_add_nested`: Adds nested data, e.g.: 
`e_add_nested("itemStyle", color, fontBold)` creates
`{itemStyle: {color: 'red', fontBold: 'bold'}}`.
- `e_add_unnested`: Adds unnested data, e.g.:
`e_add_unnested("symbolSize", size)` creates
`{symbolSize: 4}`.
}

\examples{
# funnel can take nested itemStyle
# https://echarts.apache.org/en/option.html#series-funnel.data
funnel <- data.frame(
  stage = c("View", "Click", "Purchase"),
  value = c(80, 30, 20),
  color = c("blue", "red", "green")
)

funnel |>
  e_charts() |>
  e_funnel(value, stage) |>
  e_add_nested("itemStyle", color)

# Heatmap can take nested label
# https://echarts.apache.org/en/option.html#series-heatmap.data
v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE),
  y = sample(v, 300, replace = TRUE),
  z = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) |>
  dplyr::group_by(x, y) |>
  dplyr::summarise(z = sum(z)) |>
  dplyr::ungroup() |>
  dplyr::mutate(
    show = TRUE,
    fontStyle = round(runif(dplyr::n(), 5, 12))
  )

matrix |>
  e_charts(x) |>
  e_heatmap(y, z) |>
  e_visual_map(z) |>
  e_add_nested(
    "label",
    show,
    fontStyle
  )

}
