% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarts4r.R
\name{init}
\alias{init}
\alias{e_charts}
\alias{e_charts_}
\alias{e_chart}
\alias{e_data}
\title{Initialise}
\usage{
e_charts(data, x, width = NULL, height = NULL, elementId = NULL,
  dispose = TRUE, draw = TRUE, renderer = "canvas",
  timeline = FALSE, ...)

e_charts_(data, x = NULL, width = NULL, height = NULL,
  elementId = NULL, dispose = TRUE, draw = TRUE,
  renderer = "canvas", timeline = FALSE, ...)

e_chart(data, x, width = NULL, height = NULL, elementId = NULL,
  dispose = TRUE, draw = TRUE, renderer = "canvas",
  timeline = FALSE, ...)

e_data(e, data, x)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{Column name containing x axis.}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{elementId}{Id of element.}

\item{dispose}{Set to \code{TRUE} to force redraw of chart, set to \code{FALSE} to update.}

\item{draw}{Whether to draw the chart, intended to be used with \code{\link{e_draw_p}}.}

\item{renderer}{Renderer, takes \code{canvas} (default) or \code{svg}.}

\item{timeline}{Set to \code{TRUE} to build a timeline, see timeline section.}

\item{...}{Any other argument.}

\item{e}{An object of class \code{echarts4r} as returned by \code{e_charts}.}
}
\description{
Initialise a chart.
}
\section{Timeline}{

The timeline feature currently supports the following chart types.
\itemize{
  \item{\code{\link{e_bar}}}
  \item{\code{\link{e_line}}}
  \item{\code{\link{e_step}}}
  \item{\code{\link{e_area}}}
  \item{\code{\link{e_scatter}}}
  \item{\code{\link{e_effect_scatter}}}
  \item{\code{\link{e_candle}}}
  \item{\code{\link{e_heatmap}}}
  \item{\code{\link{e_pie}}}
  \item{\code{\link{e_line_3d}}}
  \item{\code{\link{e_lines_3d}}}
  \item{\code{\link{e_bar_3d}}}
  \item{\code{\link{e_lines}}}
  \item{\code{\link{e_scatter_3d}}}
  \item{\code{\link{e_scatter_gl}}}
  \item{\code{\link{e_histogram}}}
  \item{\code{\link{e_lm}}}
  \item{\code{\link{e_loess}}}
  \item{\code{\link{e_glm}}}
  \item{\code{\link{e_density}}}
  \item{\code{\link{e_pictorial}}}
  \item{\code{\link{e_boxplot}}}
  \item{\code{\link{e_map}}}
  \item{\code{\link{e_map_3d}}}
  \item{\code{\link{e_line_3d}}}
  \item{\code{\link{e_gauge}}}
}
}

\examples{
mtcars \%>\% 
  e_charts(qsec) \%>\%
  e_line(mpg)

points <- mtcars[1:3,]
mtcars \%>\% 
  e_charts_("qsec") \%>\%
  e_line(mpg) \%>\%
  e_data(points, qsec) \%>\%
  e_scatter(mpg, color = "blue")

}
