% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sld-sd-method.R
\name{sld.sd}
\alias{sld.sd}
\alias{sld.var}
\alias{sld.mean}
\alias{sld.skewness}
\alias{sld.kurtosis}
\alias{sld.kurt}
\title{Compute statistics analytically for an sld object}
\usage{
sld.sd(object)

sld.var(object)

sld.mean(object)

sld.skewness(object)

sld.kurtosis(object)

sld.kurt(object)
}
\arguments{
\item{object}{an object of sld class}
}
\value{
numeric
}
\description{
Compute statistics for mean, var, skewness, kurtosis for SLD. 
These functions are just wrappers on \code{\link{ksl}}.
If you need to calculate the statistics in quantity, you should use \code{\link{ksl}} or \code{\link{kqsl}} directly.
}
\examples{
d <- qsld(nu0=10.4, theta=1.6, convo=2)
sld.sd(d)
sld.var(d)
sld.mean(d)
sld.skewness(d)
sld.kurt(d)

}
\author{
Stephen H-T. Lihn
}
\keyword{statistics}
