% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-stable-lambda-dist-method.R
\name{rqsl}
\alias{rqsl}
\alias{rsl}
\alias{dsl}
\alias{dqsl}
\alias{kqsl}
\alias{ksl}
\alias{qsl_kurtosis_analytic}
\alias{qsl_skewness_analytic}
\alias{qsl_variance_analytic}
\alias{qsl_std_pdf0_analytic}
\alias{qsl_pdf_integrand_analytic}
\alias{cfqsl}
\alias{cfsl}
\title{Stable lambda distribution}
\usage{
rqsl(n, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

rsl(n, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0,
  lambda = 4)

dsl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0,
  lambda = 4)

dqsl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

kqsl(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

ksl(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0,
  lambda = 4)

qsl_kurtosis_analytic(t = 1, nu0 = 0, theta = 1, convo = 1,
  beta.a = 0)

qsl_skewness_analytic(t = 1, nu0 = 0, theta = 1, convo = 1,
  beta.a = 0)

qsl_variance_analytic(t = 1, nu0 = 0, theta = 1, convo = 1,
  beta.a = 0)

qsl_std_pdf0_analytic(t = 1, nu0 = 0, theta = 1, convo = 1,
  beta.a = 0)

qsl_pdf_integrand_analytic(x, nu, t = 1, nu0 = 0, theta = 1, convo = 1,
  beta.a = 0, mu = 0)

cfqsl(s, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0,
  method = "a")

cfsl(s, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0,
  lambda = 4, method = "a")
}
\arguments{
\item{n}{numeric, number of observations.}

\item{t}{numeric, the time parameter, where the variance is t, default is 1.}

\item{nu0}{numeric, the location parameter, default is 0.}

\item{theta}{numeric, the scale parameter, default is 1.}

\item{convo}{numeric, the convolution number, default is 1.}

\item{beta.a}{numeric, the skewness parameter, default is 0. This number is annualized by sqrt(t).}

\item{mu}{numeric, the location parameter, default is 0.}

\item{lambda}{numeric, the shape parameter, default is 4.}

\item{x}{numeric, vector of responses.}

\item{nu}{numeric, vector of nu in the pdf integrand, starting from 0 (not nu0).}

\item{s}{numeric, vector of responses for characteristic function.}

\item{method}{character, method of characteristic function (CF) calculation. Default is "a".
Method a uses cflihnlap x dstablecnt.
Method b uses dlihnlap x cfstablecnt.
Method c uses direct integration on PDF up to 50 stdev.
They should yield the same result.}
}
\value{
numeric, standard convention is followed:
        d* returns the density,
        p* returns the distribution function,
        q* returns the quantile function, and
        r* generates random deviates.
        The following are our extensions:
        k* returns the first 4 cumulants, skewness, and kurtosis,
        cf* returns the characteristic function.
}
\description{
Implements some aspects of the stable lambda (SL) distribution
}
\author{
Stephen H-T. Lihn
}
\keyword{Modified-Lambda}
