% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-integrate-pdf-generic.R
\docType{methods}
\name{integrate_pdf.ecd}
\alias{integrate_pdf.ecd}
\alias{integrate_pdf}
\alias{integrate_pdf,ecd-method}
\title{Integrate a function with PDF of the distribution}
\usage{
\method{integrate_pdf}{ecd}(object, f, lower, upper, ..., show.warning = TRUE,
  verbose = FALSE)

integrate_pdf(object, f, lower, upper, ...)

\S4method{integrate_pdf}{ecd}(object, f, lower, upper, ...,
  show.warning = TRUE, verbose = FALSE)
}
\arguments{
\item{object}{An object of ecd class}

\item{f}{An R function taking a numeric first argument and 
returning a numeric vector of the same length. 
Returning a non-finite element will generate an error.}

\item{lower}{Numeric, the lower limit of integration. Can be infinite.}

\item{upper}{Numeric, the upper limit of integration. Can be infinite.}

\item{...}{Addtional arguments for \code{f}.}

\item{show.warning}{logical, display warning messages.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
A list of class "\code{integrate}".
}
\description{
Integrate a function with PDF of the distribution. 
The integration is seperated into three segments to ensure convergence.
}
\examples{
d <- ecd()
integrate_pdf(d, function(x){x^2}, -Inf, Inf)
}
\author{
Stephen H. Lihn
}
\keyword{integrate}
\keyword{pdf}
