% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-imgf-method.R
\name{ecld.imgf}
\alias{ecld.imgf}
\alias{ecld.imgf_gamma}
\alias{ecld.imgf_integrate}
\title{Incomplete moment generating function (IMGF) of ecld}
\usage{
ecld.imgf(object, k, otype = "c", RN = TRUE)

ecld.imgf_gamma(object, k, otype = "c", RN = TRUE)

ecld.imgf_integrate(object, k, otype = "c", RN = TRUE)
}
\arguments{
\item{object}{an object of ecld class}

\item{k}{a numeric vector of log-strike}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}

\item{RN}{logical, use risk-neutral assumption for \code{mu_D}}
}
\value{
numeric, incomplete MGF
}
\description{
The analytic solutions for IMGF of ecld, if available.
Note that, by default, risk neutrality is honored. However, you must note that
when fitting market data, this is usually not true.
SGED is supported.
}
\examples{
ld <- ecld(sigma=0.01)
ecld.imgf(ld,0)

}
\author{
Stephen H-T. Lihn
}
\keyword{mgf}

