% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-ppms.R
\name{ebirdst_ppms_ts}
\alias{ebirdst_ppms_ts}
\alias{plot.ebirdst_ppms_ts}
\title{Time series of eBird Status and Trends PPMs summarized temporally}
\usage{
ebirdst_ppms_ts(path, ext, summarize_by = c("weeks", "months"), ...)

\method{plot}{ebirdst_ppms_ts}(x, type = c("binary", "occurrence", "abundance"), metric = "kappa", ...)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object (optional); the spatial extent over which
to calculate the PPMs. Note that \link{ebirdst_extent} objects typically specify
both a spatial and temporal extent, however, \strong{within this function only
the spatial component of the extent is used.}}

\item{summarize_by}{character; periods over which to summarize PPMs. PPMs can
either be calculated for eBird Status and Trends weeks (as defined in
\link{ebirdst_weeks}) or for the months of the year.}

\item{...}{ignored.}

\item{x}{\link{ebirdst_ppms_ts} object; PPMs summarized by weeks or months as
calculated by \code{\link[=ebirdst_ppms_ts]{ebirdst_ppms_ts()}}.}

\item{type}{character; the PPM type to plot, either a binary, occurrence, or
abundance PPM can be plotted.}

\item{metric}{character; the specific metric to plot, the list list of
possible metrics varies by PPM type:
\itemize{
\item Binary or occurrence: \code{auc}, \code{ppc}, \code{kappa}, \code{bernoulli_dev}, \code{sensitivity},
\code{specificity}
\item Abundance: \code{poisson_dev_abd}, \code{poisson_dev_occ}, \code{spearman_abd},
\code{spearman_occ}
}}
}
\value{
An \code{ebirdst_pppms_ts} object containing a list of three data frames:
\code{binary_ppms}, \code{occ_ppms}, and \code{abd_ppms}. Each row of these data frames
corresponds to the PPMs from one Monte Carlo iteration for a given time
period. Columns correspond to the different PPMs. \code{binary_ppms} contains
binary or range-based PPMs, \code{occ_ppms} contains within-range occurrence
probability PPMs, and \code{abd_ppms} contains within-range abundance PPMs. In
some cases, PPMs may be missing, either because there isn't a large enough
test set within the spatiotemporal extent or because average occurrence or
abundance is too low. In these cases, try increasing the size of the
\link{ebirdst_extent} object. \code{plot()} can be called on the returned
\code{ebirdst_pppms_ts} object to plot a time series of a single PPM.
}
\description{
Calculate a time series of predictive performance metrics (PPMs) for the
eBird Status and Trends model. For each week or month of the year, PPMs will
be summarized independently to produce a time series. For further details on
eBird Status and Trends PPMs consult the help for \link{ebirdst_ppms}.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# define a spatial extent to calculate ppms over
e <- ebirdst_extent(c(xmin = -90, xmax = -82, ymin = 41, ymax = 48))

# compute predictive performance metrics, summarized by months
ppms <- ebirdst_ppms_ts(path = path, ext = e, summarize_by = "months")

# plot time series
# binary, kappa
plot(ppms, type = "binary", metric = "kappa")
# occurrence, sensitivity
plot(ppms, type = "occurrence", metric = "sensitivity")
#' # abundance, poisson deviance
plot(ppms, type = "abundance", metric = "poisson_dev_abd")
}
}
