% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-mapping.R
\name{calc_bins}
\alias{calc_bins}
\title{Calculates bins (breaks) based on standard deviations of Box-Cox
power-transformed data for mapping}
\usage{
calc_bins(x)
}
\arguments{
\item{x}{RasterStack or RasterBrick; original eBird Status and Trends product
raster GeoTIFF with 52 bands, one for each week.}
}
\value{
A list with two elements: \code{bins} is a vector containing the break
points of the bins and \code{power} is the optimal power used to transform data
when calculating bins.
}
\description{
Mapping species abundance across the full-annual cycle presents a challenge,
in that patterns of concentration and dispersion in abundance change
throughout the year, making it difficult to define color bins that suit all
seasons and accurately reflect the detail of abundance predictions. To
address this, we selected a method (described by Maciejewski et al. 2013)
that first selects an optimal power (the Box-Cox method) for normalizing
the data, then power transforms the entire year of non-zero data, constructs
bins with the power-transformed data using standard-deviations, and then
un-transforms the bins.
}
\examples{
# download and load example abundance data
sp_path <- ebirdst_download("example_data")
abd <- load_raster("abundance_umean", sp_path)
\dontshow{
# crop to speed up cran tests
e <-  raster::extent(abd)
e[2] <- e[1] + (e[2] - e[1]) / 4
e[4] <- e[3] + (e[4] - e[3]) / 4
abd <- raster::crop(abd[[30]], e)
}

# calculate bins for a single week for this example
year_bins <- calc_bins(abd)
}
\references{
Ross Maciejewski, Avin Pattah, Sungahn Ko, Ryan Hafen, William S.
Cleveland, David S. Ebert.  Automated Box-Cox Transformations for Improved
Visual Encoding. IEEE Transactions on Visualization and Computer Graphics,
19(1): 130-140, 2013.
}
