% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userPredictions.R
\name{predict.EAT}
\alias{predict.EAT}
\title{Model Prediction for Efficiency Analysis Trees.}
\usage{
\method{predict}{EAT}(object, newdata, x, ...)
}
\arguments{
\item{object}{An \code{EAT} object.}

\item{newdata}{\code{data.frame}. Set of input variables to predict on.}

\item{x}{Inputs index.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{data.frame} with the original data and the predicted values.
}
\description{
This function predicts the expected output by an \code{EAT} object.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

predict(object = EAT_model, newdata = simulated, x = c(1, 2))
}

}
