% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{easy_glmnet}
\alias{easy_glmnet}
\title{Easily build and evaluate a penalized regression model.}
\usage{
easy_glmnet(.data, dependent_variable, family = "gaussian", resample = NULL,
  preprocess = preprocess_scale, measure = NULL, exclude_variables = NULL,
  categorical_variables = NULL, train_size = 0.667, foldid = NULL,
  survival_rate_cutoff = 0.05, n_samples = 1000, n_divisions = 1000,
  n_iterations = 10, random_state = NULL, progress_bar = TRUE,
  n_core = 1, coefficients = TRUE, variable_importances = FALSE,
  predictions = TRUE, model_performance = TRUE, model_args = list())
}
\arguments{
\item{.data}{A data.frame; the data to be analyzed.}

\item{dependent_variable}{A character vector of length one; the dependent variable for this analysis.}

\item{family}{A character vector of length one; the type of regression to run on the data. Choices are one of c("gaussian", "binomial"). Defaults to "gaussian".}

\item{resample}{A function; the function for resampling the data. Defaults to NULL.}

\item{preprocess}{A function; the function for preprocessing the data. Defaults to NULL.}

\item{measure}{A function; the function for measuring the results. Defaults to NULL.}

\item{exclude_variables}{A character vector; the variables from the data set to exclude. Defaults to NULL.}

\item{categorical_variables}{A character vector; the variables that are categorical. Defaults to NULL.}

\item{train_size}{A numeric vector of length one; specifies what proportion of the data should be used for the training data set. Defaults to 0.667.}

\item{foldid}{A vector with length equal to \code{length(y)} which identifies cases belonging to the same fold.}

\item{survival_rate_cutoff}{A numeric vector of length one; for \code{\link{easy_glmnet}}, specifies the minimal threshold (as a percentage) a coefficient must appear out of n_samples. Defaults to 0.05.}

\item{n_samples}{An integer vector of length one; specifies the number of times the coefficients and predictions should be generated. Defaults to 1000.}

\item{n_divisions}{An integer vector of length one; specifies the number of times the data should be divided when replicating the measures of model performance. Defaults to 1000.}

\item{n_iterations}{An integer vector of length one; during each division, specifies the number of times the predictions should be generated. Defaults to 10.}

\item{random_state}{An integer vector of length one; specifies the seed to be used for the analysis. Defaults to NULL.}

\item{progress_bar}{A logical vector of length one; specifies whether to display a progress bar during calculations. Defaults to TRUE.}

\item{n_core}{An integer vector of length one; specifies the number of cores to use for this analysis. Currently only works on Mac OSx and Unix/Linux systems. Defaults to 1.}

\item{coefficients}{A logical vector of length one; whether or not to generate coefficients for this analysis.}

\item{variable_importances}{A logical vector of length one; whether or not to generate variable importances for this analysis.}

\item{predictions}{A logical vector of length one; whether or not to generate predictions for this analysis.}

\item{model_performance}{A logical vector of length one; whether or not to generate measures of model performance for this analysis.}

\item{model_args}{A list; the arguments to be passed to the algorithm specified.}
}
\value{
A list of class \code{easy_glmnet}.
}
\description{
This function wraps the easyml core framework, allowing a user 
to easily run the easyml methodology for a glmnet
model.
}
\examples{
\dontrun{
library(easyml) # https://github.com/CCS-Lab/easyml

# Gaussian
data("prostate", package = "easyml")
results <- easy_glmnet(prostate, "lpsa", 
                       n_samples = 10, n_divisions = 10, 
                       n_iterations = 2, random_state = 12345, 
                       n_core = 1, model_args = list(alpha = 1.0))

# Binomial
data("cocaine_dependence", package = "easyml")
results <- easy_glmnet(cocaine_dependence, "diagnosis", 
                       family = "binomial", 
                       exclude_variables = c("subject"), 
                       categorical_variables = c("male"), 
                       preprocess = preprocess_scale, 
                       n_samples = 10, n_divisions = 10, 
                       n_iterations = 2, random_state = 12345, 
                       n_core = 1, model_args = list(alpha = 1.0))
}
}
\seealso{
Other recipes: \code{\link{easy_analysis}},
  \code{\link{easy_avNNet}},
  \code{\link{easy_deep_neural_network}},
  \code{\link{easy_glinternet}},
  \code{\link{easy_neural_network}},
  \code{\link{easy_random_forest}},
  \code{\link{easy_support_vector_machine}}
}
