% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc.R
\name{finsert}
\alias{finsert}
\title{Create a Vector from an Index-to-Label Map}
\usage{
finsert(
  x = list(c(0, 1, 3) ~ "Neutrophil", c(2, 4, 8) ~ "Macrophage"),
  len = integer(),
  setname = TRUE,
  na = "Unknown"
)
}
\arguments{
\item{x}{The mapping of indices to labels. This can be provided in two formats:
\itemize{
\item A \code{list} of formulas, e.g., \code{list(c(0, 1) ~ "LabelA", 2 ~ "LabelB")}.
\item An \code{expression} object, e.g., \code{expression(c(0, 1) == "LabelA", 2 == "LabelB")}.
}}

\item{len}{An optional integer specifying the minimum length of the output
vector. If the highest index in \code{x} is greater than \code{len}, the
vector will be automatically extended.}

\item{setname}{A logical value. If \code{TRUE} (the default), the elements of
the output vector are named with their corresponding 0-based index (e.g., "0", "1", "2", ...).}

\item{na}{The character value used to fill positions that are not specified in
the mapping. Defaults to "Unknown".}
}
\value{
A character vector with the specified labels at the given positions.
The vector is named with 0-based indices if \code{setname} is \code{TRUE}.
}
\description{
Constructs a character vector by mapping labels to specified 0-based numeric
indices. This is a utility function often used in single-cell analysis to
assign cell type annotations to cluster IDs.
}
\examples{
# --- Example 1: Using the default formula list format ---
# This is the recommended and default usage.
mapping_formula <- list(
  c(0, 1, 3) ~ "Neutrophil",
  c(2, 4, 8) ~ "Macrophage"
)
finsert(mapping_formula)

# --- Example 2: Using the expression format for backward compatibility ---
mapping_expr <- expression(
  c(0, 1, 3) == "Neutrophil",
  c(2, 4, 8) == "Macrophage"
)
finsert(mapping_expr, len = 10, na = "Unassigned")

}
