% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_ops.R
\name{chunkPoints}
\alias{chunkPoints}
\title{Generate chunk points}
\usage{
chunkPoints(dsize, csize)
}
\arguments{
\item{dsize}{How big is the data being chunked}

\item{csize}{How big should each chunk be}
}
\value{
A 2 x N \code{\link{matrix}} where each column is a chunk. The first
row contains start points, and the second row contains end points.
}
\description{
Unexported helper function \code{ChunkPoints} from \pkg{Seurat}. This
can be quite useful when user needs to chunk some operations.
}
\examples{
### Split an index vector with 15273 elements into chunks, each of which has
### 3000 elements.
chunkPoints(15273, 3000)

}
\references{
\url{https://github.com/satijalab/seurat/blob/763259d05991d40721d
ee99c9919ec6d4491d15e/R/utilities.R#L1699}
}
