% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_create.R
\name{ensemble_create}
\alias{ensemble_create}
\alias{ensemble_create.sf}
\alias{ensemble_create.data.frame}
\title{Create ensemble of SDM predictions}
\usage{
ensemble_create(x, x.idx, w = NULL, x.var.idx = NULL, ...)

\method{ensemble_create}{sf}(x, x.idx, w = NULL, x.var.idx = NULL, ...)

\method{ensemble_create}{data.frame}(x, x.idx, w = NULL, x.var.idx = NULL, ...)
}
\arguments{
\item{x}{object of class \code{sf} or class \code{data.frame}}

\item{x.idx}{vector of column names or numerical indices;
indicates which columns in \code{x} will be used to create the ensemble}

\item{w}{weights for the ensemble; either a numeric vector the same length as \code{x} or
a data frame (or tibble) with the same number of rows as \code{x} and \code{ncol(w) == length(x.idx)}.
If w is a numeric vector, its values (i.e. the weights) must sum to 1.
The default value is \code{1 / length(x.idx)}, i.e. an unweighted ensemble}

\item{x.var.idx}{vector of column names or column indices;
indicates columns in \code{x} with variance values with which to
calculate uncertainty values for the ensemble.
If \code{x.var.idx} is specified, it must be the same length as \code{x.idx}.
Use \code{x.var.idx = NULL} (the default) if none of the predictions have associated uncertainty values;
in this case the uncertainty values for the ensemble will be calculated using the among-model uncertainty.
See the 'Details' section for more information}

\item{...}{Arguments to be passed to methods; specifically designed for passing
\code{na.rm} argument to \code{sum}}
}
\value{
An object of the same class as \code{x} with two columns appended to the data frame:
  \itemize{
    \item 'Pred_ens' - The ensemble predictions
    \item 'Var_ens' - The variance of the ensemble predictions,
      calculated using either the within-model uncertainty (if \code{x.var.idx} is specified) or
      the among-model uncertainty (if \code{x.var.idx} is \code{NULL})
  }
  Note that all other columns of \code{x} will be included in the returned object.
  Also, if \code{x} is of class \code{sf} then
  1) the geometry list-column will be the last column of the returned object and
  2) the \code{agr} attribute will be set as 'constant' for 'Pred_ens' and 'Var_ens'
}
\description{
Create a weighted or unweighted ensemble of SDM predictions, including associated uncertainty values
}
\details{
\code{ensemble_create} is designed to be used after overlaying predictions with \code{\link{overlay_sdm}} and
  (if desired) rescaling the overlaid predictions with \code{\link{ensemble_rescale}}.

  This function implements ensemble methods provided in \link{eSDM_GUI}.
  Note that it does not implement regional exclusion, which must be done manually if not using the GUI.

  Ensemble uncertainty is calculated using either the within-model uncertainty (if \code{x.var.idx} is specified) or
  the among-model uncertainty (if \code{x.var.idx} is \code{NULL}).
  See the eSDM GUI manual for applicable formulas.
}
\examples{
ensemble_create(preds.1, c("Density", "Density2"), c(0.2, 0.8))
ensemble_create(preds.1, 1:2, c(0.2, 0.8), c("Var1", "Var2"))
ensemble_create(data.frame(a = 1:5, b = 3:7), c(1, 2))

weights.df <- data.frame(runif(325), c(rep(NA, 100), runif(225)))
ensemble_create(preds.1, c("Density", "Density2"), weights.df, na.rm = TRUE)

}
