% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointSelect.R
\name{jointSelect}
\alias{jointSelect}
\title{Perform model selection using leave one out cross validation of model objects}
\usage{
jointSelect(modelfits)
}
\arguments{
\item{modelfits}{A list containing model fits of class \code{stanfit}.}
}
\value{
A matrix of delta elpd (expected log pointwise predictive density)
between model fits. Function is performed using the \code{loo} package.
}
\description{
This function performs leave one out cross validation of a list of model
fits using functions in the \code{loo} package, as described in Vehtari, Gelman,
and Gabry (2017) \url{doi:10.1007/s11222-016-9696-4}. Compare models fit using
\code{jointModel()} or models fits using \code{traditionalModel()}. See more examples
in the \href{https://bookdown.org/abigailkeller/eDNAjoint_vignette/}{Package
Vignette}.
}
\note{
Before model selection, this function makes the following check:
\itemize{
\item Input is a list of model fits of class 'stanfit'.
\item All models compared were fit wither either \code{jointModel()} or all with
\verb{traditionalModel().}
}

If any of these checks fail, the function returns an error message.
}
\examples{
\donttest{
data(greencrabData)

# Fit a model without estimating a gear scaling coefficient for traditional
# survey gear types.
# This model assumes all traditional survey methods have the same
# catchability.
# Count data is modeled using a poisson distribution.
fit.no.q <- jointModel(data = greencrabData, family = "poisson",
                       p10priors = c(1,20), q = FALSE, multicore = FALSE)


# Fit a model estimating a gear scaling coefficient for traditional
# survey gear types.
# This model does not assume all traditional survey methods have the
# same catchability.
# Gear type 1 is used as the reference gear type.
# Count data is modeled using a negative binomial distribution.
fit.q <- jointModel(data = greencrabData, family = "negbin",
                    p10priors = c(1,20), q = TRUE, multicore = FALSE)

# Perform model selection
jointSelect(modelfits = list(fit.no.q$model, fit.q$model))
}

}
