% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_dimred_projection.R
\name{add_dimred_projection}
\alias{add_dimred_projection}
\title{Constructs a trajectory by projecting cells within a dimensionality reduction}
\usage{
add_dimred_projection(
  dataset,
  milestone_ids = NULL,
  milestone_network,
  dimred,
  dimred_milestones,
  grouping = NULL,
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{milestone_ids}{The ids of the milestones in the trajectory. Type: Character vector.}

\item{milestone_network}{The network of the milestones.
Type: Data frame(from = character, to = character, length = numeric, directed = logical).}

\item{dimred}{Can be
\itemize{
\item A function which will perform the dimensionality reduction, see \code{\link[dyndimred:dimred]{dyndimred::list_dimred_methods()}}
\item A matrix with the dimensionality reduction, with cells in rows and dimensions (\emph{comp_1}, \emph{comp_2}, ...) in columns
}}

\item{dimred_milestones}{An optional dimensionality reduction of the milestones. A matrix with milestones in rows and components (\emph{comp_1}, \emph{comp_2}, ...) in columns

This will be automatically calculated if \code{project_trajectory = TRUE}}

\item{grouping}{A grouping of the cells, can be a named vector or a dataframe with \emph{group_id} and \emph{cell_id}}

\item{...}{extra information to be stored in the wrapper.}
}
\value{
A trajectory object
}
\description{
A dimensionality reduction of cells and milestones is used, along with the milestone network, to project cells onto the nearest edge. Optionally, a cell grouping can be given which will restrict the edges on which a cell can be projected.
}
\examples{
library(tibble)
dataset <- wrap_data(cell_ids = letters)

milestone_network <- tibble::tibble(
  from = c("A", "B", "B"),
  to = c("B", "C", "D"),
  directed = TRUE,
  length = 1
)
milestone_network
dimred <- matrix(
  runif(length(dataset$cell_ids) * 2),
  ncol = 2,
  dimnames = list(dataset$cell_ids, c("comp_1", "comp_2"))
)
dimred
dimred_milestones <- matrix(
  runif(2*4),
  ncol = 2,
  dimnames = list(c("A", "B", "C", "D"), c("comp_1", "comp_2"))
)
dimred_milestones
trajectory <- add_dimred_projection(
  dataset,
  milestone_network = milestone_network,
  dimred = dimred,
  dimred_milestones = dimred_milestones
)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
