% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrGetDerivs.R
\name{getdx}
\alias{getdx}
\title{A wrapper function to call functions in the fda package to obtain
smoothed estimated derivatives at a specified order}
\usage{
getdx(theTimes, norder, roughPenaltyMax, lambda, dataMatrix, derivOrder)
}
\arguments{
\item{theTimes}{The time points at which derivative estimation are requested}

\item{norder}{Order of Bsplines - usually 2 higher than roughPenaltyMax}

\item{roughPenaltyMax}{Penalization order. Usually set to 2 higher than the highest-order derivatives desired}

\item{lambda}{A positive smoothing parameter: larger --> more smoothing}

\item{dataMatrix}{Data of size total number of time points x  total number of subjects}

\item{derivOrder}{The order of the desired derivative estimates}
}
\value{
A list containing:
1. out (a matrix containing the derivative estimates
at the specified order that matches the dimension of dataMatrix); 
2. basisCoef (estimated basis coefficients); 3. basis2 (basis functions)
}
\description{
A wrapper function to call functions in the fda package to obtain
smoothed estimated derivatives at a specified order
}
\examples{
#x = getdx(theTimes,norder,roughPenaltyMax,sp,out2,0)[[1]] #Smoothed level
#dx = getdx(theTimes,norder,roughPenaltyMax,sp,out2,1)[[1]] #Smoothed 1st derivs
#d2x = getdx(theTimes,norder,roughPenaltyMax,sp,out2,2)[[1]] #Smoothed 2nd derivs
}
\references{
Chow, S-M. (2019). Practical Tools and Guidelines for Exploring and Fitting Linear 
and Nonlinear Dynamical Systems Models. Multivariate Behavioral Research. https://www.nihms.nih.gov/pmc/articlerender.fcgi?artid=1520409

Chow, S-M., *Bendezu, J. J., Cole, P. M., & Ram, N. (2016). A Comparison of Two-
Stage Approaches for Fitting Nonlinear Ordinary Differential Equation (ODE) 
Models with Mixed Effects. Multivariate Behavioral Research, 51, 154-184. Doi: 10.1080/00273171.2015.1123138.
}

