% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{EMGsim}
\alias{EMGsim}
\title{Simulated single-subject time series to capture features of facial electromyography data}
\format{A data frame with 500 rows and 6 variables}
\usage{
data(EMGsim)
}
\description{
A dataset simulated using an autoregressive model of order (AR(1)) with
regime-specific AR weight, intercept, and slope for a covariate. This model
is a special case of Model 1 in Yang and Chow (2010) in which the moving average
coefficient is set to zero.
 
 Reference:
 Yang, M-S. & Chow, S-M. (2010). Using state-space models with regime switching to 
 represent the dynamics of facial electromyography (EMG) data. Psychometrika, 74(4), 744-771
}
\details{
The variables are as follows:

\itemize{
  \item id. ID of the participant (= 1 in this case, over 500 time points)
  \item EMG. Hypothetical observed facial electromyograhy data
  \item self. Covariate - the individual's concurrent self-reports
  \item truestate. The true score of the individual's EMG at each time point
  \item trueregime. The true underlying regime for the individual at each time point
}
}
\keyword{datasets}

