% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretise.r
\name{discretise}
\alias{discretise}
\title{Discrete a catchment into hydrological response units (HRUs)}
\usage{
discretise(layers, chans, cuts = list(a = 10), area.thresh = 2/100,
  order.by = names(cuts)[[1]], chan.width = 5)
}
\arguments{
\item{layers}{A multi-band raster (stack) comprising the catchment data. This should be in a projected coordinate system (or none) and have reqular cells. The first layer should be the elevation raster, and subsequent (named) layers should supply the landscape data drawn in to create the discretisation}

\item{chans}{Raster containing channel reach locations, of the same dimensions and resolution of the DEM and other catchment layers. The reaches should be numbered sequentially and any areas not containing part of the channel should be NA. If a second band is supplied with values 0-1 then this is taken to be the proportion of the corresponding non-zero cell occuppied by the channel. If this layer is not present then the proportion is infered from the channel width as p = min(1, chan.width/xres(dem))}

\item{cuts}{A list of cuts of the form layer_name=number. Each name should correspond to a layer name in the layers parameter.}

\item{area.thresh}{Minimum area for response units, expressed as a percentage of the catchment plan area, excluding channel cells. Areas smaller than this are aggregate dwith adjacent areas until exceeding the threshold aea}

\item{order.by}{Name of layer whose values will be use to sort the response units, in decreasing order. Defaults to the name of the first cut}

\item{chan.width}{Channel width, in same units as DEM. Only used if chans doesn't contain a layer to specify the proportion of each river cell comprised of the channel.}
}
\value{
A list comprising the following

weights	Flux distribution (weighting) matrix. A ngroup x ngroup matrix defining the downslope flux distributions between groups, between land and the channel, and between channel reaches, where nh is the number of land discretisations identified by applying cuts to the catchment layers and nc the numbbr of channel reaches defined. The nth row gives the proportions of flow out of HRU #n to other response units and the channel. Row sums should thus always add to 1. The m th column gives the proportion of flow from the other response units into the m th group.

groups A data frame whose rows comprising the names, plan area and model parameters of each response unit. See Beven and Freer (2001) and Metcalfe et al (2015) for a description of these parameters

hru	Multi-band raster comprising the original rasters that the specifed cuts were applied to produce the discretisation; the channel network;the resultant response unit locations
}
\description{
Discrete a catchment into a set hydrological response units (HRUs) according to any number of landscape layers and cuts
}
\details{
This applies the given cuts to the supplied landscape layers to produce areal groupings of the catchment.
}
\examples{
# Landcover and soils are fairly homogenous throughout the Brompton catchment;
# storm response of the appears to be mostly controlled by proximity to the
# channel network. A simple discretisation according to flow distance from the
# nearest channel thus appears to capture the dynamics during the  2012 event
# without introducing unnecessary complexity.
\dontrun{
require(dynatopmodel)

data(brompton)

chans <- build.chans(brompton$dem, drn=brompton$drn, chan.width=2)
# sort by distance but want areas closest the channel to come first
layers <- addLayer(brompton$dem, 2000-brompton$flowdists)
disc <- discretise(layers, cuts=c(flowdists=5), chans=chans, area.thresh=2/100)

write.table(disc$groups, sep="\\t", row.names=FALSE)
}
}

