% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_spec}
\alias{random_spec}
\title{Additional Specifications for the Group-level Random Effects of the DMPM}
\usage{
random_spec(correlated = TRUE, noncentered = TRUE)
}
\arguments{
\item{correlated}{[\code{logical(1)}]\cr If \code{TRUE} (the default), correlations
of random effects are modeled as multivariate normal.}

\item{noncentered}{[\code{logical(1)}]\cr If \code{TRUE} (the default), use a
noncentered parameterization for random effects. Try changing this if
you encounter divergences or other problems in sampling.}
}
\value{
An object of class \code{random_spec}.
}
\description{
This function can be used as part of \code{\link[=dynamiteformula]{dynamiteformula()}} to define
whether the group-level random effects should be modeled as correlated or
not.
}
\details{
With a large number of time points random intercepts can become challenging
sample with default priors. This is because with large group sizes the
group-level intercepts tend to be behave similarly to fixed group-factor
variable so the model becomes overparameterized given these and the common
intercept term. Another potential cause for sampling problems is relatively
large variation in the intercepts (large sigma_nu) compared to the sampling
variation (sigma) in the Gaussian case.
}
\examples{
# two channel model with correlated random effects for responses x and y
obs(y ~ 1 + random(~1), family = "gaussian") +
  obs(x ~ 1 + random(~1 + z), family = "poisson") +
  random_spec(correlated = TRUE)

}
\seealso{
Model formula construction
\code{\link{dynamiteformula}()},
\code{\link{dynamite}()},
\code{\link{lags}()},
\code{\link{lfactor}()},
\code{\link{splines}()}
}
\concept{formulas}
