/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.SpinBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public final class FontChooserPanel
extends JPanel {
    private SpinBox m_fontSize;
    private JComboBox m_font = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    private JCheckBox m_bold;
    private JCheckBox m_italic;

    public FontChooserPanel(String currentFont, int currentStyle, int currentSize) {
        super(new GridBagLayout());
        this.m_font.setSelectedItem(currentFont);
        this.m_bold = new JCheckBox("Bold", (currentStyle & 1) != 0);
        this.m_italic = new JCheckBox("Italic", (currentStyle & 2) != 0);
        this.m_bold.setMnemonic('B');
        this.m_italic.setMnemonic('I');
        this.m_fontSize = new SpinBox(currentSize, 0, 100);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        JPanel temp = new JPanel(new FlowLayout(1));
        temp.add(new JLabel("Font: "));
        temp.add(this.m_font);
        this.add((Component)temp, c);
        temp = new JPanel(new FlowLayout(1));
        temp.add(new JLabel("Font size (points): "));
        temp.add(this.m_fontSize);
        this.add((Component)temp, c);
        temp = new JPanel(new FlowLayout(1));
        temp.add(this.m_bold);
        temp.add(this.m_italic);
        this.add((Component)temp, c);
    }

    public boolean inputIsValid() {
        try {
            return this.getSpecifiedFont() != null;
        }
        catch (Throwable e) {
            if (e instanceof NumberFormatException) {
                JOptionPane.showMessageDialog(this, "An invalid number was supplied: ".concat(e.getMessage()), "Invalid number", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Exception occurred while creating font: ".concat(e.toString()), "Invalid font", 0);
            }
            return false;
        }
    }

    public Font getSpecifiedFont() {
        int style = 0;
        if (this.m_bold.isSelected()) {
            style |= 1;
        }
        if (this.m_italic.isSelected()) {
            style |= 2;
        }
        return new Font((String)this.m_font.getSelectedItem(), style, this.m_fontSize.getValue());
    }

    public void addKeyListener(KeyListener l) {
        this.m_fontSize.addKeyListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_bold.addChangeListener(l);
        this.m_italic.addChangeListener(l);
    }

    public void addItemListener(ItemListener l) {
        this.m_font.addItemListener(l);
    }
}

