/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import criteres.Critere;
import criteres.CritereActif;
import criteres.CritereActifIllustratif;
import criteres.CritereAjout;
import criteres.CritereAppartient;
import criteres.CritereCompose;
import criteres.CritereGroupe;
import criteres.CritereHabGroupeContinue;
import criteres.CritereIndividu;
import criteres.CritereModNominale;
import criteres.CritereNominale;
import criteres.CritereRestriction;
import criteres.CritereVariableContinue;
import criteres.Trieur;
import don.Continue;
import don.ContinueAnalysee;
import don.ContinueMoyenne;
import don.Dimension;
import don.DonneeID;
import don.DonneeParse;
import don.Individu;
import don.IndividuMoyen;
import don.Modalite;
import don.ModaliteMoyenne;
import don.Nominale;
import don.NominaleArtificielleGroupe;
import don.NullDonneeParse;
import don.Partitionnable;
import don.Qualifiable;
import don.ValeurTest;
import don.Variable;
import drawing.Canvas;
import drawing.ConfAffichage;
import drawing.Registre;
import drawing.Series;
import dyn.Araignee;
import dyn.Bubble;
import dyn.Graphe;
import dyn.NuagePoint;
import dyn.Vecteur;
import exceptions.ExceptionIntegrite;
import ihm.FenetreDescriptionContinue;
import ihm.FenetreErreur;
import ihm.Habilleur;
import ihm.IHM;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.annotations.XYIDAnnotation;
import outils.Fichier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gestionnaire {
    private DonneeParse m_don;
    public static final int INDIVIDUS = 0;
    public static final int VARIABLES = 1;
    public static final int GROUPES = 2;
    public static final int AXES_PARTIELS = 3;
    public static final int DATAFRAME = 4;
    public static final int NB_TYPES_MAX = 5;
    private int m_type;
    private String[] m_titres;
    private String[] m_titresX;
    private String[] m_titresY;
    private IHM m_interf;
    private Vector<DonneeID> m_selectionnes;
    private ContinueAnalysee[] m_axeX;
    private ContinueAnalysee[] m_axeY;
    private boolean m_affGrid;
    private Graphe m_graphe;
    private SortedSet<Series> series;
    private HashMap<DonneeID, Boolean> annotation;
    private HashMap<DonneeID, Boolean> fantome;
    private HashMap<DonneeID, Boolean> partiel;
    private Vector<DonneeID> courante;
    private Vector<DonneeID> affichable;
    private boolean m_affLegende;
    private double[] rapport;
    private Habilleur m_habilleur_facto;
    private Habilleur m_habilleur_data;
    private boolean m_ortho;

    public Gestionnaire(IHM interf) {
        this.m_don = interf.getDonneeParse();
        this.courante = new Vector();
        this.affichable = new Vector();
        this.m_interf = interf;
        this.m_selectionnes = new Vector();
        this.setValDefaut();
    }

    private boolean all(HashMap<DonneeID, Boolean> table, boolean val) {
        for (boolean t : table.values()) {
            if (t == val) continue;
            return false;
        }
        return true;
    }

    public boolean isAffPartiels(DonneeID obj) {
        if (obj != null) {
            for (DonneeID don : this.partiel.keySet()) {
                if (!don.equals(obj)) continue;
                return this.partiel.get(don);
            }
        }
        return false;
    }

    public boolean isAffPartiels() {
        return !this.all(this.partiel, false);
    }

    private boolean isAffPartiels(Vector<DonneeID> obj) {
        Iterator<DonneeID> iter = obj.iterator();
        while (iter.hasNext()) {
            if (this.partiel.get(iter.next()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isAffPartielsDonnesEnCours() {
        if (this.getSelectionnes().size() == 0) {
            return this.isAffPartiels(this.getAffichable());
        }
        return this.isAffPartiels(this.getSelectionnes());
    }

    public void setAffPartiels(Vector<DonneeID> obj, boolean val) {
        this.sauverAnnotations();
        for (DonneeID donnee : obj) {
            this.partiel.put(donnee, val);
        }
        this.updateGraphe();
    }

    public void setAffPartielsDonnesEnCours(boolean val) {
        if (this.getSelectionnes().size() == 0) {
            this.setAffPartiels(this.getAffichable(), val);
        } else {
            this.setAffPartiels(this.getSelectionnes(), val);
        }
    }

    @Deprecated
    public void setAffPartiels(Vector<DonneeID> obj) {
        this.setAffPartiels(obj, true);
    }

    public boolean isAffGrid() {
        return this.m_affGrid;
    }

    public void setAffGrid(boolean b) {
        this.m_affGrid = b;
        this.m_graphe.affGrid();
    }

    public boolean isAnnotations() {
        return !this.all(this.annotation, false);
    }

    public boolean isAnnotations(Vector<DonneeID> obj) {
        if (obj != null) {
            Iterator<DonneeID> iter = obj.iterator();
            while (iter.hasNext()) {
                if (this.annotation.get(iter.next()).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAnnotationsDonnesEnCours() {
        if (this.getSelectionnes().size() == 0) {
            return this.isAnnotations(this.getAffichable());
        }
        return this.isAnnotations(this.getSelectionnes());
    }

    public boolean isAnnotations(DonneeID obj) {
        return this.annotation.get(obj) != false && (this.getType() == 4 || this.getType() != 4 && !this.getHabilleur().isSousSeuilAffinage(obj));
    }

    public void setAnnotations(DonneeID obj, boolean val) {
        Vector<DonneeID> vect = new Vector<DonneeID>();
        vect.add(obj);
        this.setAnnotations(vect, val);
    }

    public void setAnnotationsDonnesEnCours(boolean val) {
        if (this.getSelectionnes().size() == 0) {
            this.setAnnotations(this.getAffichable(), val);
        } else {
            this.setAnnotations(this.getSelectionnes(), val);
        }
    }

    public void setAnnotations(Vector<DonneeID> obj, boolean val) {
        this.sauverAnnotations();
        for (DonneeID donnee : obj) {
            this.annotation.put(donnee, val);
        }
        this.m_graphe.affAnnotation();
    }

    public boolean isFantome() {
        return this.courante.size() == 0;
    }

    public boolean isContientFantome() {
        return !this.all(this.fantome, false);
    }

    public boolean isContientFantome(Vector<DonneeID> obj) {
        if (this.fantome != null && obj != null) {
            if (obj.size() == 0) {
                return this.isFantome();
            }
            Iterator<DonneeID> iter = obj.iterator();
            while (iter.hasNext()) {
                if (!this.fantome.get(iter.next()).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isContientFantomeDonnesEnCours() {
        if (this.getSelectionnes().size() == 0) {
            return this.isContientFantome(this.getAffichable());
        }
        return this.isContientFantome(this.getSelectionnes());
    }

    public boolean isFantome(Vector<DonneeID> obj) {
        if (this.fantome != null) {
            if (obj.size() == 0) {
                return this.isFantome();
            }
            Iterator<DonneeID> iter = obj.iterator();
            while (iter.hasNext()) {
                if (this.fantome.get(iter.next()).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isFantome(DonneeID obj) {
        if (this.fantome.get(obj) == null) {
            return false;
        }
        return this.fantome.get(obj);
    }

    private void setFantome(Vector<DonneeID> obj, boolean val) {
        this.sauverAnnotations();
        if (!this.isIndividusVisibles()) {
            this.getHabilleur().supprimerHabillage(0);
        }
        for (DonneeID donnee : obj) {
            this.fantome.put(donnee, val);
        }
        if (val) {
            this.m_selectionnes.removeAll(obj);
        }
        this.updateGraphe();
    }

    public boolean isIndividusVisibles() {
        for (DonneeID don : this.courante) {
            if (!(don instanceof Individu)) continue;
            return true;
        }
        return false;
    }

    public boolean isModalitesVisibles() {
        for (DonneeID don : this.courante) {
            if (!(don instanceof Modalite)) continue;
            return true;
        }
        return false;
    }

    private boolean isIllustratifsVisibles() {
        for (DonneeID don : this.courante) {
            if (don.isActive()) continue;
            return true;
        }
        return false;
    }

    public void setFantomeDonnesEnCours(boolean val) {
        if (this.getSelectionnes().size() == 0) {
            this.setFantome(this.getAffichable(), val);
        } else {
            this.setFantome(this.getSelectionnes(), val);
        }
    }

    public DonneeParse getDon() {
        return this.m_don;
    }

    @Deprecated
    public void setHabillage(Variable habillage) {
        this.sauverAnnotations();
        if (habillage instanceof ContinueAnalysee) {
            this.getHabilleur().setHabillage(0, (ContinueAnalysee)habillage, 1);
        } else {
            this.getHabilleur().setHabillage(0, habillage);
        }
        this.updateGraphe();
    }

    public void setHabillage(int type_donnees, Variable habillage) {
        this.getHabilleur().setHabillage(type_donnees, habillage);
    }

    public void setHabillage(int type_donnees, Continue habillage, int styleHabillage) {
        this.getHabilleur().setHabillage(type_donnees, habillage, styleHabillage);
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.sauverAnnotations();
        this.m_type = type;
        this.m_selectionnes.clear();
        this.mettreAJourIHM();
    }

    public void mettreAJourIHM() {
        this.m_interf.redemarrer();
    }

    public Vector<DonneeID> getSelectionnes() {
        return this.m_selectionnes;
    }

    public void inverserSelectionnes() {
        this.sauverAnnotations();
        Vector<DonneeID> ancienneSelection = new Vector<DonneeID>(this.m_selectionnes);
        this.m_selectionnes.clear();
        this.m_selectionnes.addAll(this.getCourant());
        this.m_selectionnes.removeAll(ancienneSelection);
        this.m_interf.updateMenuBarre();
        this.updateGraphe();
    }

    public void setSelectionnes(Vector<DonneeID> selectionnes) {
        this.sauverAnnotations();
        this.m_selectionnes = selectionnes;
        this.m_interf.updateMenuBarre();
        this.updateGraphe();
    }

    public void addSelectionnes(Collection<DonneeID> selectionnes) {
        this.sauverAnnotations();
        for (DonneeID donnee : selectionnes) {
            if (donnee instanceof Partitionnable) {
                if (((Partitionnable)donnee).getGeneration() != 0 || this.m_selectionnes.contains(donnee)) continue;
                this.m_selectionnes.add(donnee);
                continue;
            }
            if (this.m_selectionnes.contains(donnee)) continue;
            this.m_selectionnes.add(donnee);
        }
        this.m_interf.updateMenuBarre();
        this.updateGraphe();
    }

    public void addSelectionnes(DonneeID selectionnes) {
        this.sauverAnnotations();
        this.m_selectionnes.add(selectionnes);
        this.m_interf.updateMenuBarre();
        this.updateGraphe();
    }

    public void rmSelectionnes() {
        this.sauverAnnotations();
        this.m_selectionnes.clear();
        this.m_interf.updateMenuBarre();
        this.updateGraphe();
    }

    public ContinueAnalysee getAxeX() {
        return this.m_axeX[this.getType()];
    }

    public void setAxeX(ContinueAnalysee axeX) {
        if (this.getType() == 4) {
            this.m_axeX[4] = axeX;
        } else {
            this.m_axeX[0] = axeX;
            this.m_axeX[2] = axeX;
            this.m_axeX[3] = axeX;
            this.m_axeX[1] = axeX;
            this.m_habilleur_facto.setAxeX(axeX);
            this.m_habilleur_data.setAxeX(axeX);
        }
    }

    public ContinueAnalysee getAxeY() {
        return this.m_axeY[this.getType()];
    }

    public void setAxeY(ContinueAnalysee axeY) {
        if (this.getType() == 4) {
            this.m_axeY[4] = axeY;
        } else {
            this.m_axeY[0] = axeY;
            this.m_axeY[2] = axeY;
            this.m_axeY[3] = axeY;
            this.m_axeY[1] = axeY;
            this.m_habilleur_facto.setAxeY(axeY);
            this.m_habilleur_data.setAxeY(axeY);
        }
    }

    public boolean isPlanFactoriel() {
        return this.getAxeX() instanceof Dimension && this.getAxeY() instanceof Dimension;
    }

    public ChartPanel getPanel() {
        return this.m_interf.getChartPanel();
    }

    public void setPanel(ChartPanel panel) {
        this.m_interf.setChartPanel(panel);
    }

    public void setCanvas(Canvas canvas) {
        if (this.m_interf.getChartPanel() != null) {
            this.m_interf.getChartPanel().setGestionnaire(this);
            this.m_interf.getChartPanel().setCanvas(canvas);
        }
    }

    public Canvas getCanvas() {
        if (this.m_interf.getChartPanel() != null) {
            return this.m_interf.getChartPanel().getCanvas();
        }
        return null;
    }

    public void setCourant() {
        this.courante = new Vector();
        for (Series s : this.series) {
            int i = 0;
            while (i < s.getNbDonneeID()) {
                if (!this.isFantome(s.getDonneeID(i))) {
                    this.courante.add(s.getDonneeID(i));
                }
                ++i;
            }
        }
    }

    public void setAffichable() {
        this.affichable = new Vector();
        for (Series s : this.series) {
            int i = 0;
            while (i < s.getNbDonneeID()) {
                this.affichable.add(s.getDonneeID(i));
                ++i;
            }
        }
    }

    public Vector<DonneeID> getCourant() {
        return this.courante;
    }

    public Vector<DonneeID> getAffichable() {
        return this.affichable;
    }

    public void setDonnee() {
        this.m_don = new NullDonneeParse();
        this.setValDefaut();
        this.m_interf.setDonneeParse(this.m_don);
    }

    public void setValDefaut(ConfAffichage aff) {
        if (aff != null) {
            this.m_type = aff.getType();
            this.series = new TreeSet<Series>();
            this.setCourant();
            this.setAffichable();
            this.m_axeX = aff.getAxeX();
            this.m_axeY = aff.getAxeY();
            this.annotation = aff.getAnnotation();
            this.partiel = aff.getPartiel();
            this.fantome = aff.getFantome();
            this.m_affGrid = aff.isAffGrille();
            this.m_habilleur_facto = aff.getHabilleurFacto(this.m_don);
            this.m_habilleur_data = aff.getHabilleurData(this.m_don);
            this.m_titres = aff.getTitresGraphe();
            this.m_titresX = aff.getTitresX();
            this.m_titresY = aff.getTitreY();
            this.m_ortho = true;
        } else {
            this.setValDefaut();
        }
    }

    public void setValDefaut() {
        this.m_type = this.m_don.getType() == DonneeParse.TypeAnalyse.DATAFRAME ? 4 : (this.m_don.getType() == DonneeParse.TypeAnalyse.AUTRE && this.m_don.isRepDataframePossible() ? 4 : 0);
        this.m_axeX = new ContinueAnalysee[5];
        this.m_axeY = new ContinueAnalysee[5];
        int i = 0;
        while (i < 4) {
            this.m_axeX[i] = this.m_don.getAxe(0);
            this.m_axeY[i] = this.m_don.getAxe(1);
            ++i;
        }
        if (this.m_don.isRepDataframePossible()) {
            this.m_axeX[4] = this.m_don.getVariablesMoyennes().get(0);
            this.m_axeY[4] = this.m_don.getVariablesMoyennes().get(1);
        }
        if (this.annotation == null) {
            this.annotation = new HashMap();
        }
        if (this.partiel == null) {
            this.partiel = new HashMap();
        }
        if (this.fantome == null) {
            this.fantome = new HashMap();
        }
        for (DonneeID donnee : this.m_don.toDonneeID()) {
            this.annotation.put(donnee, true);
            this.partiel.put(donnee, false);
            this.fantome.put(donnee, false);
        }
        this.m_affGrid = false;
        this.m_titres = new String[5];
        this.m_titresX = new String[5];
        this.m_titresY = new String[5];
        this.rapport = new double[5];
        i = 0;
        while (i < 5) {
            this.m_titresX[i] = null;
            this.m_titresY[i] = null;
            this.m_titres[i] = null;
            this.rapport[i] = 1.0;
            ++i;
        }
        this.m_habilleur_facto = new Habilleur(this.m_don, this.getAxeX(), this.getAxeY());
        this.m_habilleur_data = new Habilleur(this.m_don, this.getAxeX(), this.getAxeY());
        this.m_affLegende = false;
        this.m_ortho = true;
    }

    private String getTitreYDefautAvecInertie() {
        return String.valueOf(this.getTitreYDefaut()) + " (" + this.getInertieY() + ")";
    }

    private String getTitreXDefautAvecInertie() {
        return String.valueOf(this.getTitreXDefaut()) + " (" + this.getInertieX() + ")";
    }

    public void ouvrir(String chemin) {
        try {
            Registre reg = Fichier.chargerDonnees(chemin);
            if (reg != null) {
                DonneeParse chargees = reg.getDonnee();
                chargees.verifierIntegrite();
                this.m_don = chargees;
                this.setValDefaut(reg.getConfAffichage());
                this.m_interf.setDonneeParse(chargees);
            }
        }
        catch (Exception e) {
            new FenetreErreur(e);
        }
    }

    public void enregistrer(String chemin) {
        try {
            this.sauverAnnotations();
            this.m_don.verifierIntegrite();
            Registre reg = new Registre(this.m_don, new ConfAffichage(this.getType(), this.m_titres, this.m_titresX, this.m_titresY, this.annotation, this.partiel, this.fantome, this.m_axeX, this.m_axeY, this.isAffGrid(), this.m_habilleur_facto, this.m_habilleur_data));
            Fichier.serialiser(reg, chemin);
        }
        catch (ExceptionIntegrite e) {
            new FenetreErreur(e);
        }
    }

    public void sauverAnnotations() {
        if (this.getPanel() != null && this.getPanel().getCanvas() != null) {
            Vector<DonneeID> id = this.m_don.toDonneeID();
            Vector<DonneeID> idUtil = new Vector<DonneeID>(id);
            for (DonneeID donnee : idUtil) {
                if (donnee instanceof IndividuMoyen) {
                    id.addAll(((IndividuMoyen)donnee).getBranches());
                    continue;
                }
                if (donnee instanceof ContinueMoyenne) {
                    id.addAll(((ContinueMoyenne)donnee).getBranches());
                    continue;
                }
                if (!(donnee instanceof ModaliteMoyenne)) continue;
                id.addAll(((ModaliteMoyenne)donnee).getBranches());
            }
            Vector<XYIDAnnotation> mesAnnot = this.getPanel().getCanvas().getVectAnnot();
            int j = 0;
            while (j < mesAnnot.size()) {
                XYIDAnnotation annot = mesAnnot.get(j);
                boolean fait = false;
                int i = 0;
                while (i < id.size() && !fait) {
                    DonneeID donnee = id.get(i);
                    String txt = donnee.getAnnotation();
                    if (donnee instanceof Partitionnable && ((Partitionnable)donnee).getGeneration() > 0) {
                        txt = String.valueOf(donnee.getAnnotation()) + " (" + donnee.getGr().getAnnotation() + ")";
                    }
                    if (annot.getAnnot().equals(txt)) {
                        donnee.setXYannot(this.getAxeX(), this.getAxeY(), annot.getLblx(), annot.getLbly(), annot.getTextAnchor());
                        fait = true;
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public void updateGraphe() {
        this.prepareDonnees();
        this.afficheGraphe();
    }

    private boolean isHabContinue() {
        boolean hab_continue = false;
        if (this.getType() == 0) {
            hab_continue = this.getHabilleur().getHabillageContinu(0) != null || this.getHabilleur().getHabillageContinu(1) != null;
        } else if (this.getType() == 1 || this.getType() == 3) {
            hab_continue = this.getHabilleur().getHabillageContinu(2) != null;
        } else if (this.getType() == 2) {
            hab_continue = false;
        } else if (this.getType() == 4) {
            hab_continue = this.getHabilleur().getHabillageContinu(0) != null && this.getHabilleur().getHabillageStyleContinu(0) == 0;
        }
        return hab_continue;
    }

    public void prepareDonnees() {
        CritereCompose critereFinal;
        CritereCompose affichage = new CritereCompose();
        if (this.getType() == 0 || this.getType() == 4) {
            if (this.getHabilleur().getHabillageDiscret(0) != null) {
                affichage.addCritere(new CritereNominale((Nominale)this.getHabilleur().getHabillageDiscret(0)));
            } else {
                affichage.addCritere(new CritereIndividu());
            }
            Iterator<Nominale> iter = this.m_don.getNominales().iterator();
            Vector<Nominale> actives = new Vector<Nominale>();
            Vector<Nominale> illustratives = new Vector<Nominale>();
            while (iter.hasNext()) {
                Nominale nom = iter.next();
                if (nom.isModActif()) {
                    actives.add(nom);
                    continue;
                }
                illustratives.add(nom);
            }
            for (Nominale nominale : illustratives) {
                affichage.addCritere(new CritereModNominale(nominale));
            }
            for (Nominale nominale : actives) {
                affichage.addCritere(new CritereModNominale(nominale));
            }
        } else if (this.getType() == 1) {
            Variable var = this.getHabilleur().getHabillageDiscret(2);
            Critere habillage = var != null && var instanceof NominaleArtificielleGroupe ? new CritereHabGroupeContinue() : (this.getType() == 1 ? new CritereVariableContinue() : new CritereVariableContinue(IHM.getXmlLangue().getElement("CaxePart")));
            affichage.addCritere(new CritereRestriction(habillage, new CritereAppartient(this.m_don.getVariablesMoyennes())));
        } else if (this.getType() == 3) {
            affichage.addCritere(new CritereRestriction(new CritereHabGroupeContinue(), new CritereAppartient(this.m_don.getAxesPartiels())));
        } else if (this.getType() == 2) {
            affichage.addCritere(new CritereGroupe());
        }
        CritereAjout affichageSelection = new CritereAjout(affichage, new CritereAppartient(this.m_selectionnes){

            public String semantique() {
                return String.valueOf(IHM.getXmlLangue().hashCode());
            }
        });
        Trieur t = new Trieur(affichageSelection);
        t.trier(this.m_don.toDonneeID());
        this.series = t.getSeries();
        this.setCourant();
        if (this.getType() != 3) {
            if (!this.isIllustratifsVisibles()) {
                boolean affIllustratifsNecessaire = false;
                if (this.getType() == 0) {
                    for (Nominale nom : this.m_don.getNominales()) {
                        if (nom.isModActif()) continue;
                        affIllustratifsNecessaire = true;
                    }
                }
                critereFinal = affIllustratifsNecessaire ? new CritereRestriction(affichageSelection, new CritereActifIllustratif()) : new CritereRestriction(affichageSelection, new CritereActif());
            } else {
                critereFinal = new CritereRestriction(affichageSelection, new CritereActifIllustratif());
            }
        } else {
            critereFinal = affichageSelection;
        }
        if (this.isHabContinue()) {
            critereFinal = new CritereRestriction(this.getHabilleur().getCriterePositifNegatif(), critereFinal);
        }
        if (this.getType() != 4) {
            critereFinal = new CritereRestriction(critereFinal, this.getHabilleur().getCritereSeuilAffinage());
        }
        t = new Trieur(critereFinal);
        t.trier(this.m_don.toDonneeID());
        this.series = t.getSeries();
        this.setCourant();
        this.setAffichable();
    }

    private void afficheGraphe() {
        String titre = this.getTitreGraphe();
        String titreX = this.getTitreX();
        String titreY = this.getTitreY();
        if (this.getType() == 0) {
            boolean hab_bulles;
            boolean bl = hab_bulles = this.getHabilleur().getHabillageContinu(0) != null && this.getHabilleur().getHabillageStyleContinu(0) == 0 || this.getHabilleur().getHabillageContinu(1) != null && this.getHabilleur().getHabillageStyleContinu(1) == 0;
            this.m_graphe = hab_bulles ? new Bubble(this, this.getHabilleur(), titre, titreX, titreY) : (this.isAffPartiels() ? new Araignee(this, this.getHabilleur(), titre, titreX, titreY) : new NuagePoint(this, this.getHabilleur(), titre, titreX, titreY));
        } else if (this.getType() == 1 || this.getType() == 3) {
            this.m_graphe = new Vecteur(this, this.getHabilleur(), titre, titreX, titreY);
        } else if (this.getType() == 2) {
            this.m_graphe = new NuagePoint(this, this.getHabilleur(), titre, titreX, titreY);
        } else if (this.getType() == 4) {
            this.m_graphe = this.isHabContinue() ? new Bubble(this, this.getHabilleur(), titre, titreX, titreY) : new NuagePoint(this, this.getHabilleur(), titre, titreX, titreY);
        }
        this.setCanvas(new Canvas());
        this.m_graphe.update(this.series);
    }

    public String getTitreYDefaut() {
        if (this.getAxeY() == null) {
            return "*error";
        }
        return this.getAxeY().getNom();
    }

    public String getTitreXDefaut() {
        if (this.getAxeX() == null) {
            return "*error";
        }
        return this.getAxeX().getNom();
    }

    public String getInertieY() {
        ContinueAnalysee axe = this.getAxeY();
        if (axe instanceof Dimension) {
            return DonneeParse.pourcentage(this.m_don.getInerties()[((Dimension)axe).getNum()]);
        }
        return null;
    }

    public String getInertieX() {
        ContinueAnalysee axe = this.getAxeX();
        if (axe instanceof Dimension) {
            return DonneeParse.pourcentage(this.m_don.getInerties()[((Dimension)axe).getNum()]);
        }
        return null;
    }

    public void setTitreAxeX(String titre) {
        this.m_interf.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabel(titre);
        this.m_titresX[this.m_type] = titre;
    }

    public void setTitreAxeY(String titre) {
        this.m_interf.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabel(titre);
        this.m_titresY[this.m_type] = titre;
    }

    private String getTitreX() {
        String titreX = this.m_titresX[this.m_type];
        if (titreX == null) {
            titreX = this.getType() != 4 ? this.getTitreXDefautAvecInertie() : this.getTitreXDefaut();
        }
        return titreX;
    }

    private String getTitreY() {
        String titreY = this.m_titresY[this.m_type];
        if (titreY == null) {
            titreY = this.getType() != 4 ? this.getTitreYDefautAvecInertie() : this.getTitreYDefaut();
        }
        return titreY;
    }

    public void setTitreGraphe(String titre) {
        this.m_interf.getChartPanel().getChart().setTitle(titre);
        this.m_titres[this.m_type] = titre;
    }

    private String getTitreGraphe() {
        String titre = this.m_titres[this.m_type];
        if (this.m_don.getType() == DonneeParse.TypeAnalyse.CA) {
            titre = IHM.getXmlLangue().getElement("LGrapheAFC");
        } else if (titre == null) {
            switch (this.m_type) {
                case 0: {
                    titre = IHM.getXmlLangue().getElement("MtypeGRInd");
                    break;
                }
                case 1: {
                    titre = IHM.getXmlLangue().getElement("MtypeGRVar");
                    break;
                }
                case 2: {
                    titre = IHM.getXmlLangue().getElement("MtypeGRGr");
                    break;
                }
                case 3: {
                    titre = IHM.getXmlLangue().getElement("MtypeGRAxesPart");
                    break;
                }
                case 4: {
                    titre = IHM.getXmlLangue().getElement("MtypeGRAxesDataframe");
                    break;
                }
                default: {
                    titre = IHM.getXmlLangue().getElement("erreur");
                }
            }
        }
        return titre;
    }

    public boolean isAffLegende() {
        return this.m_affLegende;
    }

    public void setAffLegende(boolean b) {
        this.m_affLegende = b;
        this.updateGraphe();
    }

    public void setRapport(double value) {
        this.rapport[this.m_type] = value;
    }

    public double getRapport() {
        return this.rapport[this.m_type];
    }

    public Habilleur getHabilleur() {
        if (this.getType() == 4) {
            return this.m_habilleur_data;
        }
        return this.m_habilleur_facto;
    }

    public JFrame getIHM() {
        return this.m_interf;
    }

    public void setAxeX(int axeX) {
        this.setAxeX(this.m_don.getAxe(axeX));
    }

    public void setAxeY(int axeY) {
        this.setAxeY(this.m_don.getAxe(axeY));
    }

    public boolean isOrtho() {
        return this.m_ortho;
    }

    public void setOrtho(boolean b) {
        this.m_ortho = b;
    }

    public void setAffinage(double d) {
        this.getHabilleur().setSeuilAffinage(d);
        this.sauverAnnotations();
        this.updateGraphe();
    }

    public double getSeuilAffinage() {
        return this.getHabilleur().getSeuilAffinage();
    }

    public boolean isAffinagePossible() {
        return this.m_type != 4 && this.m_don != null && !(this.m_don instanceof NullDonneeParse);
    }

    public void setDescription(Qualifiable qualifiable) {
        if (qualifiable != null) {
            this.getHabilleur().setDescription(new ValeurTest(qualifiable));
            if (!(qualifiable instanceof Modalite)) {
                FenetreDescriptionContinue.montrer(this.m_interf, this.m_don, qualifiable);
            }
        } else {
            this.getHabilleur().setDescription(null);
        }
    }
}

