/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.tabbed.TabPreviewThread;
import org.jvnet.lafwidget.tabbed.TabPreviewWindow;

public class TabHoverPreviewWidget
extends LafWidgetAdapter {
    protected JTabbedPane jtp;
    protected MouseRolloverHandler baseRolloverHandler;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.jtp = (JTabbedPane)jcomp;
    }

    public void installListeners() {
        this.baseRolloverHandler = new MouseRolloverHandler();
        this.jtp.addMouseMotionListener(this.baseRolloverHandler);
        this.jtp.addMouseListener(this.baseRolloverHandler);
    }

    public void uninstallListeners() {
        if (this.baseRolloverHandler != null) {
            this.jtp.removeMouseMotionListener(this.baseRolloverHandler);
            this.jtp.removeMouseListener(this.baseRolloverHandler);
            this.baseRolloverHandler = null;
        }
    }

    public void uninstallUI() {
        if (TabPreviewThread.instanceRunning()) {
            TabPreviewThread.getInstance().cancelTabPreviewRequests(this.jtp);
            TabPreviewWindow.getInstance().cancelPreviewRequest();
        }
        super.uninstallUI();
    }

    public boolean requiresCustomLafSupport() {
        return true;
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;

        protected MouseRolloverHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TabPreviewWindow.getInstance().cancelPreviewRequest();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != TabHoverPreviewWidget.this.jtp) {
                return;
            }
            LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
            int currRolledOver = lafSupport.getRolloverTabIndex(TabHoverPreviewWidget.this.jtp);
            if (currRolledOver >= TabHoverPreviewWidget.this.jtp.getTabCount()) {
                return;
            }
            if (currRolledOver != TabHoverPreviewWidget.this.jtp.getSelectedIndex()) {
                if (currRolledOver == this.prevRolledOver) {
                    if (currRolledOver >= 0 && currRolledOver < TabHoverPreviewWidget.this.jtp.getTabCount() && TabHoverPreviewWidget.this.jtp.isEnabledAt(currRolledOver)) {
                        TabPreviewWindow.getInstance().postPreviewRequest(TabHoverPreviewWidget.this.jtp, currRolledOver);
                    }
                } else {
                    if (this.prevRolledOver >= 0 && this.prevRolledOver < TabHoverPreviewWidget.this.jtp.getTabCount() && TabHoverPreviewWidget.this.jtp.isEnabledAt(this.prevRolledOver)) {
                        TabPreviewWindow.getInstance().cancelPreviewRequest();
                    }
                    if (currRolledOver >= 0 && currRolledOver < TabHoverPreviewWidget.this.jtp.getTabCount() && TabHoverPreviewWidget.this.jtp.isEnabledAt(currRolledOver)) {
                        TabPreviewWindow.getInstance().postPreviewRequest(TabHoverPreviewWidget.this.jtp, currRolledOver);
                    }
                }
            } else {
                TabPreviewWindow.getInstance().cancelPreviewRequest();
            }
            this.prevRolledOver = currRolledOver;
        }

        public void mouseExited(MouseEvent e) {
            if (this.prevRolledOver >= 0 && this.prevRolledOver < TabHoverPreviewWidget.this.jtp.getTabCount() && TabHoverPreviewWidget.this.jtp.isEnabledAt(this.prevRolledOver)) {
                TabPreviewWindow.getInstance().cancelPreviewRequest();
            }
            this.prevRolledOver = -1;
        }
    }
}

