% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparql.R
\name{sparql}
\alias{sparql}
\title{Execute SPARQL query against a dataset.}
\usage{
sparql(dataset, query, query_params = list())
}
\arguments{
\item{dataset}{Dataset URL or path.}

\item{query}{SPARQL query.}

\item{query_params}{List of named query parameters.}
}
\value{
Data frame with data from query results.
}
\description{
#' \strong{EXPERIMENTAL}: This is an experimental feature and
backwards-compability is not guaranteed in future releases.
}
\examples{
\dontrun{
 dwapi::sparql(dataset="user/dataset",
   query="SELECT *
          WHERE {
            ?s ?p ?o .
          } LIMIT 10")

dwapi::sparql(dataset="user/dataset",
  query="SELECT *
         WHERE {
         [ :Year ?year ; :Region ?region ; :Indicator_Coverage_and_Disaggregation ?score ]
         FILTER(?score > $v1)
         } LIMIT 10",
  queryParameters = list("$v1"=5.5))
}
}
