% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cov_n}
\alias{cov_n}
\title{Sample Covariance for Numeric Vectors}
\usage{
cov_n(x, y)
}
\arguments{
\item{x, y}{Numeric vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[stats]{cov}} for numeric vectors. For integer vectors, 
\code{\link{cov_i}} should run even faster.
}
\examples{
# In general, cov_n is much faster than cov
x <- rnorm(1000)
y <- rnorm(1000)
all.equal(cov(x, y), cov_n(x, y))
benchmark(cov(x, y), cov_n(x, y), replications = 5000)

# For integer vectors, cov_i should be even faster.
x <- rpois(1000, lambda = 5)
y <- rpois(1000, lambda = 5)
all.equal(cov(x, y), cov_i(x, y))
benchmark(cov(x, y), cov_n(x, y), cov_i(x, y), replications = 5000)

}
