% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fallback.R
\name{fallback}
\alias{fallback}
\alias{fallback_sitrep}
\alias{fallback_config}
\alias{fallback_review}
\alias{fallback_upload}
\alias{fallback_purge}
\title{Fallback to dplyr}
\usage{
fallback_sitrep()

fallback_config(
  ...,
  reset_all = FALSE,
  info = NULL,
  logging = NULL,
  autoupload = NULL,
  log_dir = NULL,
  verbose = NULL
)

fallback_review(oldest = NULL, newest = NULL, detail = TRUE)

fallback_upload(oldest = NULL, newest = NULL, strict = TRUE)

fallback_purge(oldest = NULL, newest = NULL)
}
\arguments{
\item{...}{These dots are for future extensions and must be empty.}

\item{reset_all}{Set to \code{TRUE} to reset all settings to their defaults.
The R session must be restarted for the changes to take effect.}

\item{info}{Set to \code{TRUE} to enable fallback printing.}

\item{logging}{Set to \code{FALSE} to disable fallback logging,
set to \code{TRUE} to explicitly enable it.}

\item{autoupload}{Set to \code{TRUE} to enable automatic fallback uploading,
set to \code{FALSE} to disable it.}

\item{log_dir}{Set the location of the logs in the file system.
The directory will be created if it does not exist.}

\item{verbose}{Set to \code{TRUE} to enable verbose logging.}

\item{oldest, newest}{The number of oldest or newest reports to review.
If not specified, all reports are dispayed.}

\item{detail}{Print the full content of the reports.
Set to \code{FALSE} to only print the file names.}

\item{strict}{If \code{TRUE}, the function aborts if any of the reports fail to upload.
With \code{FALSE}, only a message is printed.}
}
\description{
The \pkg{duckplyr} package aims at providing
a fully compatible drop-in replacement for \pkg{dplyr}.
To achieve this, only a carefully selected subset of \pkg{dplyr}'s operations,
R functions, and R data types are implemented.
Whenever a request cannot be handled by DuckDB,
\pkg{duckplyr} falls back to \pkg{dplyr}.
See \verb{vignette("fallback"})` for details.

To assist future development, the fallback situations can be logged
to the console or to a local file and uploaded for analysis.
By default, \pkg{duckplyr} will not log or upload anything.
The functions and environment variables on this page control the process.

\code{fallback_sitrep()} prints the current settings for fallback printing, logging,
and uploading, the number of reports ready for upload, and the location of the logs.

\code{fallback_config()} configures the current settings for fallback printing,
logging, and uploading.
Only settings that do not affect computation results can be configured,
this is by design.
The configuration is stored in a file under \code{tools::R_user_dir("duckplyr", "config")} .
When the \pkg{duckplyr} package is loaded, the configuration is read from this file,
and the corresponding environment variables are set.

\code{fallback_review()} prints the available reports for review to the console.

\code{fallback_upload()} uploads the available reports to a central server for analysis.
The server is hosted on AWS and the reports are stored in a private S3 bucket.
Only authorized personnel have access to the reports.

\code{fallback_purge()} deletes some or all available reports.
}
\details{
Logging is on by default, but can be turned off.
Uploading is opt-in.

The following environment variables control the logging and uploading:
\itemize{
\item \code{DUCKPLYR_FALLBACK_INFO} controls human-friendly alerts
for fallback events.
If \code{TRUE}, a message is printed when a fallback to dplyr occurs
because DuckDB cannot handle a request.
These messages are never logged.
\item \code{DUCKPLYR_FALLBACK_COLLECT} controls logging, set it
to 1 or greater to enable logging.
If the value is 0, logging is disabled.
Future versions of \pkg{duckplyr} may start logging additional data
and thus require a higher value to enable logging.
Set to 99 to enable logging for all future versions.
Use \code{\link[usethis:edit]{usethis::edit_r_environ()}} to edit the environment file.
\item \code{DUCKPLYR_FALLBACK_AUTOUPLOAD} controls uploading, set it
to 1 or greater to enable uploading.
If the value is 0, uploading is disabled.
Currently, uploading is active if the value is 1 or greater.
Future versions of \pkg{duckplyr} may start logging additional data
and thus require a higher value to enable uploading.
Set to 99 to enable uploading for all future versions.
Use \code{\link[usethis:edit]{usethis::edit_r_environ()}} to edit the environment file.
\item \code{DUCKPLYR_FALLBACK_LOG_DIR} controls the location of the logs.
It must point to a directory (existing or not) where the logs will be written.
By default, logs are written to a directory in the user's cache directory
as returned by \code{tools::R_user_dir("duckplyr", "cache")}.
\item \code{DUCKPLYR_FALLBACK_VERBOSE} controls printing of log data, set it
to \code{TRUE} or \code{FALSE} to enable or disable printing.
If the value is \code{TRUE}, a message is printed to the console
for each fallback situation.
This setting is only relevant if logging is enabled,
and mostly useful for \pkg{duckplyr}'s internal tests.
}

All code related to fallback logging and uploading is in the
\href{https://github.com/tidyverse/duckplyr/blob/main/R/fallback.R}{\code{fallback.R}} and
\href{https://github.com/tidyverse/duckplyr/blob/main/R/telemetry.R}{\code{telemetry.R}} files.
}
\examples{
fallback_sitrep()
}
