# Generated by 02-duckplyr_df-methods.R
#' @export
arrange.duckplyr_df <- function(.data, ..., .by_group = FALSE, .locale = NULL) {
  force(.data)

  dots <- enquos(...)
  dots <- unname(dots)

  if (.by_group) {
    dots <- c(quos(!!!groups(.data)), dots)
  }

  rel_try(
    ".locale argument not supported" = !is.null(.locale),
    "dplyr.legacy_locale not supported" = isTRUE(getOption("dplyr.legacy_locale")),
    {
      # Translate to df before early exit, so that we can bail out for subclasses
      rel <- duckdb_rel_from_df(.data)
      if (length(dots) == 0) {
        return(.data)
      }

      exprs <- rel_translate_dots(dots, .data)

      if (oo_force()) {
        rel <- oo_prep(rel, force = TRUE)
        exprs <- c(exprs, list(relexpr_reference("___row_number")))
      }

      rel <- rel_order(rel, exprs)

      # Don't need to sort here, already sorting by ___row_number
      if (oo_force()) {
        out_rel <- oo_restore_cols(rel)
      } else {
        out_rel <- rel
      }

      out <- rel_to_df(out_rel)
      out <- dplyr_reconstruct(out, .data)
      return(out)
    }
  )

  # dplyr forward
  arrange <- dplyr$arrange.data.frame
  out <- arrange(.data, ..., .by_group = .by_group, .locale = .locale)
  return(out)

  # dplyr implementation
  dots <- enquos(...)

  if (.by_group) {
    dots <- c(quos(!!!groups(.data)), dots)
  }

  loc <- arrange_rows(.data, dots = dots, locale = .locale)
  dplyr_row_slice(.data, loc)
}

duckplyr_arrange <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- arrange(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
