% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shape-extraction.R
\name{shape_extraction}
\alias{shape_extraction}
\title{Shape average of several time series}
\usage{
shape_extraction(X, cz = NULL, znorm = TRUE)
}
\arguments{
\item{X}{Numeric matrix where each row is a time series.}

\item{cz}{Center to use as basis. It should already be \emph{normalized}. Calculation uses all \code{X}
if \code{cz = NULL}.}

\item{znorm}{Boolean flag. Should z-scores be calculated for \code{X} before processing?}
}
\value{
Centroid time series.
}
\description{
Time-series shape extraction based on optimal alignments as proposed by Papparizos and Gravano, 2015, for
the k-Shape clustering algorithm.
}
\details{
This works only if the signals are \emph{z-normalized}, since the output will also have this normalization.

This centroid computation is casted as an optimization problem called maximization of Rayleigh Quotient.
See the cited article for more details.
}
\examples{
# Sample data
data(uciCT)

# Subset of interest, normalized
X <- t(sapply(CharTraj[1:5], zscore))

# Obtain centroid series
C <- shape_extraction(X, znorm = FALSE)

# Result
matplot(t(X), type = "l", col = 1:5)
points(C)
}
\references{
Paparrizos J and Gravano L (2015). ``k-Shape: Efficient and Accurate Clustering of Time Series.'' In \emph{Proceedings of the 2015
ACM SIGMOD International Conference on Management of Data}, series SIGMOD '15, pp. 1855-1870. ISBN 978-1-4503-2758-9, \url{
http://doi.org/10.1145/2723372.2737793}.
}
\seealso{
\code{\link{SBD}}, \code{\link{zscore}}
}

