% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-twdtwTimeSeries.R, R/methods.R
\docType{methods}
\name{twdtwTimeSeries-class}
\alias{[,twdtwTimeSeries,ANY,ANY,ANY-method}
\alias{[[,twdtwTimeSeries,ANY,ANY-method}
\alias{as.list,twdtwTimeSeries-method}
\alias{dim,twdtwTimeSeries-method}
\alias{index,twdtwTimeSeries-method}
\alias{is.twdtwTimeSeries}
\alias{is.twdtwTimeSeries,ANY-method}
\alias{labels,twdtwTimeSeries-method}
\alias{length,twdtwTimeSeries-method}
\alias{levels,twdtwTimeSeries-method}
\alias{ncol,twdtwTimeSeries-method}
\alias{nrow,twdtwTimeSeries-method}
\alias{show,twdtwTimeSeries-method}
\alias{twdtwTimeSeries}
\alias{twdtwTimeSeries,ANY-method}
\alias{twdtwTimeSeries-class}
\title{class "twdtwTimeSeries"}
\usage{
\S4method{twdtwTimeSeries}{ANY}(..., labels = NULL)

\S4method{dim}{twdtwTimeSeries}(x)

\S4method{index}{twdtwTimeSeries}(x)

\S4method{nrow}{twdtwTimeSeries}(x)

\S4method{ncol}{twdtwTimeSeries}(x)

\S4method{length}{twdtwTimeSeries}(x)

\S4method{as.list}{twdtwTimeSeries}(x)

\S4method{[}{twdtwTimeSeries,ANY,ANY,ANY}(x, i)

\S4method{[[}{twdtwTimeSeries,ANY,ANY}(x, i)

\S4method{labels}{twdtwTimeSeries}(object)

\S4method{levels}{twdtwTimeSeries}(x)

\S4method{show}{twdtwTimeSeries}(object)

\S4method{is.twdtwTimeSeries}{ANY}(x)
}
\arguments{
\item{...}{\code{\link[dtwSat]{twdtwTimeSeries}} objects, 
\code{\link[zoo]{zoo}} objects or a list of \code{\link[zoo]{zoo}} objects.}

\item{labels}{a vector with labels of the time series.}

\item{x}{an object of class twdtwTimeSeries.}

\item{i}{indices of the time series.}

\item{object}{an object of class twdtwTimeSeries.}
}
\description{
Class for set of irregular time series.
}
\section{Methods (by generic)}{
\itemize{
\item \code{twdtwTimeSeries}: Create object of class twdtwTimeSeries.

\item \code{is.twdtwTimeSeries}: Check if the object belongs to the class twdtwTimeSeries.
}}
\section{Slots }{

\describe{
 \item{\code{timeseries}:}{A list of \code{\link[zoo]{zoo}} objects.}
 \item{\code{labels}:}{A vector of class \code{\link[base]{factor}} with time series labels.}
}
}
\examples{
# Creating new object of class twdtwTimeSeries  
ptt = new("twdtwTimeSeries", timeseries = patterns.list, labels = names(patterns.list))
class(ptt)
labels(ptt)
levels(ptt)
length(ptt)
nrow(ptt)
ncol(ptt)
dim(ptt)
# Creating objects of class twdtwTimeSeries from zoo objects
ts = twdtwTimeSeries(example_ts)
ts 

# Creating objects of class twdtwTimeSeries from list of zoo objects 
patt = twdtwTimeSeries(patterns.list)
patt

# Joining objects of class twdtwTimeSeries 
tsA = twdtwTimeSeries(example_ts.list[[1]], labels = "A")
tsB = twdtwTimeSeries(B = example_ts.list[[2]])
ts = twdtwTimeSeries(tsA, tsB, C=example_ts)
ts
 
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwRaster-class}}, 
\code{\link[dtwSat]{getTimeSeries}}, and
\code{\link[dtwSat]{twdtwApply}}
}

