% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{full_join.trackr_df}
\alias{full_join.trackr_df}
\title{Full join}
\usage{
\method{full_join}{trackr_df}(
  x,
  y,
  ...,
  .messages = c("{.count.lhs} on LHS", "{.count.rhs} on RHS",
    "{.count.out} in linked set"),
  .headline = "Full join by {.keys}"
)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{Other parameters passed onto methods.}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, \{.keys\} for the joining columns, \{.count.lhs\},
\{.count.rhs\}, \{.count.out\} for the input and output dataframes sizes
respectively}

\item{.headline}{a glue spec. The glue code can use any global variable,
\{.keys\} for the joining columns, \{.count.lhs\}, \{.count.rhs\},
\{.count.out\} for the input and output dataframes sizes respectively}
}
\value{
the join of the two dataframes with the history graph updated.
}
\description{
Mutating joins behave as \code{dplyr} joins, except the history graph of the two
sides of the joins is merged resulting in a tracked dataframe with the
history of both input dataframes. See \code{\link[dplyr:mutate-joins]{dplyr::full_join()}} for more details
on the underlying functions.
}
\examples{
library(dplyr)
library(dtrackr)
# Joins across data sets

# example data uses the dplyr starways data
people = starwars \%>\% select(-films, -vehicles, -starships)
films = starwars \%>\% select(name,films) \%>\% tidyr::unnest(cols = c(films))

lhs = people \%>\% track() \%>\% comment("People df {.total}")
rhs = films \%>\% track() \%>\% comment("Films df {.total}") \%>\%
  comment("a test comment")

# Full join
join = lhs \%>\% full_join(rhs, by="name", multiple = "all") \%>\% comment("joined {.total}")
# See what the history of the graph is:
join \%>\% history()
nrow(join)
# Display the tracked graph (not run in examples)
# join \%>\% flowchart()

}
\seealso{
dplyr::full_join()
}
