% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf2quantile.R
\name{cdf2quantile}
\alias{cdf2quantile}
\title{Inverse cumulative distribution function}
\usage{
cdf2quantile(p, cdf, interval = c(-3, 3), ...)
}
\arguments{
\item{p}{numeric vector of probabilities.}

\item{cdf}{function, cumulative distribution function which to invert.}

\item{interval}{numeric vector of length 2, determining the lower and upper bound of the uniroot interval}

\item{...}{other arguments for the cdf, e.g. mu, sigma_v, sigma_u, s...}
}
\value{
Numeric vector of \code{p} evaluated in the inverse cdf.
}
\description{
Inverse cumulative distribution function
}
\details{
Code is a clone from the package 'gbutils'.
}
\examples{
q=5
cdf <- pnorm(q=q, mean=1, sd=2)
q_numeric <- cdf2quantile(p=cdf, cdf=pnorm, mean=1, sd=2)
all.equal(q,q_numeric)

}
