% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial.R
\name{Epgo23}
\alias{Epgo23}
\title{Expected probability to do third phase III trial}
\usage{
Epgo23(HRgo, d2, alpha, beta, w, hr1, hr2, id1, id2)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule}

\item{d2}{total number of events in phase II}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}
}
\value{
The output of the function \code{Epgo23()} is the probability to a third phase III trial.
}
\description{
In the setting of Case 2: Strategy 2/2( + 1); at least two trials significant (and the
treatment effect of the other one at least showing in the same direction) this function calculates the probability that a third phase III trial is necessary.
}
\examples{
res <- Epgo23(HRgo = 0.8, d2 = 50,  w = 0.3, alpha = 0.025, beta = 0.1,
                               hr1 =  0.69, hr2 = 0.81, id1 = 280, id2 = 420)
}
\keyword{internal}
