% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_dispensing_models}
\alias{f_dispensing_models}
\title{Drug Dispensing Model Fit}
\usage{
f_dispensing_models(
  target_days,
  vf,
  model_k0,
  model_t0,
  model_ki,
  model_di,
  nreps,
  showplot = TRUE
)
}
\arguments{
\item{target_days}{A vector of target number of days between two
drug dispensing visits by drug.}

\item{vf}{A data frame for subject-level drug dispensing data,
including the following variables:
\code{drug}, \code{drug_name}, \code{dose_unit},
\code{usubjid}, \code{treatment}, \code{treatment_description},
\code{arrivalTime}, \code{time}, \code{event}, \code{dropout},
\code{day}, \code{dose}, \code{cum_dose}, and \code{row_id}.}

\item{model_k0}{The model for the number of skipped
visits between randomization and the first drug dispensing visit.}

\item{model_t0}{The model for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.}

\item{model_ki}{The model for the number of skipped
visits between two consecutive drug dispensing visits.}

\item{model_di}{The model for the dispensed doses at drug
dispensing visits.}

\item{nreps}{The number of simulations for drawing posterior model
parameters.}

\item{showplot}{A Boolean variable that controls whether or not to
show the model fit plot. It defaults to \code{TRUE}.}
}
\value{
A list with the following components:

* \code{common_time_model} A Boolean variable that indicates whether
a common time model is used for drug dispensing visits.

* \code{fit_k0} The model fit for the number of skipped
visits between randomization and the first drug dispensing visit.

* \code{fit_t0} The model fit for the gap time between randomization
and the first drug dispensing visit when there is no visit skipping.

* \code{fit_t1} The model fit for the gap time between randomization
and the first drug dispensing visit when there is visit skipping.

* \code{fit_ki} The model fit for the number of skipped
visits between two consecutive drug dispensing visits.

* \code{fit_ti} The model fit for the gap time between two
consecutive drug dispensing visits.

* \code{fit_di} The model fit for the dispensed doses at drug
dispensing visits.
}
\description{
Fits drug dispensing models to the observed drug
dispensing data.
}
\examples{
library(dplyr)

df <- df2 \%>\%
  mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity),
            .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

fit <- f_dispensing_models(
  target_days = dosing_schedule_df$target_days, vf,
  model_k0 = "zip", model_t0 = "log-logistic",
  model_ki = "zip", model_di = "lme",
  nreps = 200, showplot = FALSE)

fit$fit_ki$fit_plot
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
