% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_fn.R
\name{jack_logodds}
\alias{jack_logodds}
\title{Compute jackknife log-odds estimates.}
\usage{
jack_logodds(treat, covar, out, treat_form, out_model, out_levels, out_form)
}
\arguments{
\item{treat}{A \code{numeric} vector containing treatment status. Should only assume 
a value 0 or 1.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}
}
\value{
Jackknife estimated log-odds
}
\description{
Compute jackknife log-odds estimates.
}
