% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_medx.R
\name{post_medx}
\alias{post_medx}
\alias{post_medx.dreamer_bma}
\alias{post_medx.dreamer}
\title{Posterior Distribution of Minimum X\% Effective Dose}
\usage{
post_medx(
  x,
  ed,
  probs,
  time,
  lower,
  upper,
  greater,
  small_bound,
  return_samples,
  ...
)

\method{post_medx}{dreamer_bma}(
  x,
  ed,
  probs = c(0.025, 0.975),
  time = NULL,
  lower = min(x$doses),
  upper = max(x$doses),
  greater = TRUE,
  small_bound = 0,
  return_samples = FALSE,
  ...
)

\method{post_medx}{dreamer}(
  x,
  ed,
  probs = c(0.025, 0.975),
  time = NULL,
  lower = min(attr(x, "doses")),
  upper = max(attr(x, "doses")),
  greater = TRUE,
  small_bound = 0,
  return_samples = FALSE,
  index = 1:(nrow(x[[1]]) * length(x)),
  ...
)
}
\arguments{
\item{x}{output from \code{dreamer_mcmc()}.}

\item{ed}{a number between 0 and 100 indicating the ed\% dose that is
being sought.}

\item{probs}{a vector of quantiles to calculate on the posterior.}

\item{time}{the slice of time for which to calculate the posterior EDX dose.
Applies to longitudinal models only.}

\item{lower}{the lower bound of the doses for calculating EDX.}

\item{upper}{the upper bound of the doses for calculating EDX.}

\item{greater}{if \code{TRUE}, higher values indicate better efficacy.  If
\code{FALSE}, lower responses indicate better efficacy.}

\item{small_bound}{the minimum (\code{greater = TRUE}) or maximum
(\code{greater = FALSE}) bound of the response.}

\item{return_samples}{logical indicating if the posterior samples should be
returned.}

\item{...}{additional arguments for specific methods.}

\item{index}{a vector indicating which MCMC samples to use in the
calculation.  If \code{NULL} (default), all MCMC samples are used.}
}
\value{
Posterior quantities and samples (if applicable),
generally in the form of a list.  The \code{pr_edx_exists} column gives the
posterior probability that an EDX\% effect exists.
}
\description{
Posterior Distribution of Minimum X\% Effective Dose
}
\details{
The minimum X\% effective dose is the dose that has X\% of the
largest effect for doses between \code{lower} and \code{upper}.  When \code{greater}
is \code{TRUE}, larger positive responses are considered more effective and
vice versa.  The X\% response is calculated as \code{small_bound} +
\code{ed} / 100 * (max_effect - \code{small_bound}) where "max_effect" is the
maximum response for doses between \code{lower} and \code{upper}.  The X\% effective
dose is the smallest dose which has X\% response within the dose range.
It is possible that for some MCMC samples, an X\% effective dose may
not exist, so probabilities are not guaranteed to sum to one.
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e4,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

post_medx(output, ed = c(50, 90))

# from a single model
post_medx(output$mod_linear, ed = c(50, 90))
}
