% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_plan.R
\name{transform_plan}
\alias{transform_plan}
\title{Transform a plan
\lifecycle{maturing}}
\usage{
transform_plan(plan, envir = parent.frame(), trace = FALSE,
  max_expand = NULL, tidy_eval = TRUE)
}
\arguments{
\item{plan}{A \code{drake} plan with a \code{transform} column}

\item{envir}{Environment for tidy evaluation.}

\item{trace}{Logical, whether to add columns to show
what happens during target transformations.}

\item{max_expand}{Positive integer, optional upper bound on the lengths
of grouping variables for \code{map()} and \code{cross()}. Comes in handy
when you have a massive number of targets and you want to test
on a miniature version of your workflow before you scale up
to production.}

\item{tidy_eval}{Logical, whether to use tidy evaluation
(e.g. unquoting/\code{!!}) when resolving commands.
Tidy evaluation in transformations is always turned on
regardless of the value you supply to this argument.}
}
\description{
Evaluate the \code{map()}, \code{cross()}, \code{split()} and
\code{combine()} operations in the \code{transform} column of a
\code{drake} plan.
}
\details{
\url{https://ropenscilabs.github.io/drake-manual/plans.html#large-plans} # nolint
}
\examples{
plan1 <- drake_plan(
  y = target(
    f(x),
    transform = map(x = c(1, 2))
  ),
  transform = FALSE
)
plan2 <- drake_plan(
  z = target(
    g(y),
    transform = map(y, .id = x)
  ),
  transform = FALSE
)
plan <- bind_plans(plan1, plan2)
transform_plan(plan)
models <- c("glm", "hierarchical")
plan <- drake_plan(
  data = target(
    get_data(x),
    transform = map(x = c("simulated", "survey"))
  ),
  analysis = target(
    analyze_data(data, model),
    transform = cross(data, model = !!models, .id = c(x, model))
  ),
  summary = target(
    summarize_analysis(analysis),
    transform = map(analysis, .id = c(x, model))
  ),
  results = target(
    bind_rows(summary),
    transform = combine(summary, .by = data)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
# Tags:
drake_plan(
  x = target(
    command,
    transform = map(y = c(1, 2), .tag_in = from, .tag_out = c(to, out))
  ),
  trace = TRUE
)
plan <- drake_plan(
  survey = target(
    survey_data(x),
    transform = map(x = c(1, 2), .tag_in = source, .tag_out = dataset)
  ),
  download = target(
    download_data(),
    transform = map(y = c(5, 6), .tag_in = source, .tag_out = dataset)
  ),
  analysis = target(
    analyze(dataset),
    transform = map(dataset)
  ),
  results = target(
    bind_rows(analysis),
    transform = combine(analysis, .by = source)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
}
\seealso{
drake_plan, map, split, cross, combine
}
