% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cached_unplanned}
\alias{cached_unplanned}
\title{List targets in the cache but not the plan.
\lifecycle{stable}}
\usage{
cached_unplanned(
  plan,
  path = NULL,
  cache = drake::drake_cache(path = path),
  namespace = NULL,
  jobs = 1
)
}
\arguments{
\item{plan}{A drake plan.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{namespace}{Character scalar, name of the storr namespace
to use for listing objects.}

\item{jobs}{Number of jobs/workers for parallel processing.}
}
\value{
A character vector of target and sub-target names.
}
\description{
Includes dynamic sub-targets as well.
See examples for details.
}
\examples{
\dontrun{
isolate_example("cache_unplanned() example", {
plan <- drake_plan(w = 1)
make(plan)
cached_unplanned(plan)
plan <- drake_plan(
  x = seq_len(2),
  y = target(x, dynamic = map(x))
)
cached_unplanned(plan)
make(plan)
cached_unplanned(plan)
# cached_unplanned() helps clean superfluous targets.
cached()
clean(list = cached_unplanned(plan))
cached()
})
}
}
\seealso{
\code{\link[=cached]{cached()}}, \link{cached_planned}
}
