% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-examples.R
\name{clean_mtcars_example}
\alias{clean_mtcars_example}
\title{Clean the mtcars example from \code{drake_example("mtcars")}}
\usage{
clean_mtcars_example()
}
\value{
nothing
}
\description{
This function deletes files. Use at your own risk.
Destroys the \code{.drake/} cache and the \code{report.Rmd} file
in the current working directory. Your working directory
(\code{getcwd()}) must be the folder from which you first ran
\code{load_mtcars_example()} and \code{make(my_plan)}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
# Populate your workspace and write 'report.Rmd'.
load_mtcars_example() # Get the code: drake_example("mtcars")
# Check the dependencies of an imported function.
deps_code(reg1)
# Check the dependencies of commands in the workflow plan.
deps_code(my_plan$command[1])
deps_code(my_plan$command[4])
# Plot the interactive network visualization of the workflow.
config <- drake_config(my_plan)
outdated(config) # Which targets are out of date?
# Run the workflow to build all the targets in the plan.
make(my_plan)
outdated(config) # Everything should be up to date.
# For the reg2() model on the small dataset,
# the p-value is so small that there may be an association
# between weight and fuel efficiency after all.
readd(coef_regression2_small)
# Clean up the example.
clean_mtcars_example()
}
})
}
}
\seealso{
\code{\link[=load_mtcars_example]{load_mtcars_example()}}, \code{\link[=clean]{clean()}}
}
