% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Makefile.R
\name{mk}
\alias{mk}
\title{Build a target inside a \code{Makefile}
during \code{make(..., parallelism = "Makefile")}.}
\usage{
mk(target = character(0), cache_path = drake::default_cache_path())
}
\arguments{
\item{target}{name of target to make}

\item{cache_path}{path to the drake cache}
}
\value{
\code{NULL}
}
\description{
Users should not need to call this function directly.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# This function is meant to be part of Makefile recipes for
# make(..., parallelism = "Makefile").
# These examples peer into the internals of drake,
# but are not really of practical use for most users.
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan) # Internal configuration list.
# Prepare to use a distributed computing parallel backend
# such as "Makefile" or "future_lapply".
# The following happens during make().
store_drake_config(config = config)
prepare_distributed(config = config)
# Write the dummy timestamp files usually written at the beginning
# of make(..., parallelism = "Makefile").
time_stamps(config = config)
# Use mk() to build a target. Usually called inside a Makefile recipe.
mk(target = "small", cache_path = default_cache_path())
})
}
}
\keyword{internal}
