% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{deps_target}
\alias{deps_target}
\title{List the dependencies of one or more targets}
\usage{
deps_target(target, config = read_drake_config(),
  character_only = FALSE)
}
\arguments{
\item{target}{a symbol denoting a target name, or if \code{character_only}
is TRUE, a character scalar denoting a target name.}

\item{config}{an output list from \code{\link[=drake_config]{drake_config()}}}

\item{character_only}{logical, whether to assume target is a character
string rather than a symbol.}
}
\value{
Names of dependencies listed by type (object, input file, etc).
}
\description{
Intended for debugging and checking your project.
The dependency structure of the components of your analysis
decides which targets are built and when.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan)
deps_target("regression1_small", config = config)
})
}
}
\seealso{
\code{\link[=deps_code]{deps_code()}}
}
