% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{coef.dr4pl}
\alias{coef.dr4pl}
\title{Obtain coefficients of a 4PL model}
\usage{
\method{coef}{dr4pl}(object, ...)
}
\arguments{
\item{object}{A 'dr4pl' object}

\item{...}{arguments passed to coef}
}
\value{
A vector of parameters
}
\description{
This function obtains the coefficients of a 4PL model. Estimates
of the four parameters, the upper asymptote, IC50, slope and lower asymptote,
are returned.
}
\examples{
obj.dr4pl <- dr4pl(Response ~ Dose, data = sample_data_2)  # Fit a 4PL model to data
coef(obj.dr4pl)  # Print parameter estimates

obj.dr4pl <- dr4pl(Response ~ Dose, data = sample_data_3)  # Fit a 4PL model to data
coef(obj.dr4pl)  # Print parameter estimates

}
