% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-build.R, R/sql-query.R, R/sql-render.R
\name{sql_build}
\alias{join_query}
\alias{select_query}
\alias{semi_join_query}
\alias{set_op_query}
\alias{sql_build}
\alias{sql_render}
\title{Build and render SQL from a sequence of lazy operations}
\usage{
sql_build(op, con, ...)

select_query(from, select = sql("*"), where = character(),
  group_by = character(), having = character(), order_by = character(),
  limit = NULL, distinct = FALSE)

join_query(x, y, type = "inner", by = NULL, suffix = c(".x", ".y"))

semi_join_query(x, y, anti = FALSE, by = NULL)

set_op_query(x, y, type = type)

sql_render(query, con = NULL, ...)
}
\arguments{
\item{op}{A sequence of lazy operations}

\item{con}{A database connection. The default \code{NULL} uses a set of
rules that should be very similar to ANSI 92, and allows for testing
without an active database connection.}

\item{...}{Other arguments passed on to the methods. Not currently used.}
}
\description{
\code{sql_build} creates a \code{select_query} S3 object, that is rendered
to a SQL string by \code{sql_render}. The output from \code{sql_build} is
designed to be easy to test, as it's database diagnostic, and has
a hierarchical structure.
}
\details{
\code{sql_build} is generic over the lazy operations, \link{lazy_ops},
and generates an S3 object that represents the query. \code{sql_render}
takes a query object and then calls a function that is generic
over the database. For example, \code{sql_build.op_mutate} generates
a \code{select_query}, and \code{sql_render.select_query} calls
\code{sql_select}, which has different methods for different databases.
The default methods should generate ANSI 92 SQL where possible, so you
backends only need to override the methods if the backend is not ANSI
compliant.
}
\keyword{internal}

