% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{buildClonalGermline}
\alias{buildClonalGermline}
\title{\code{buildClonalGermline} Determine consensus clone sequence and create germline for clone}
\usage{
buildClonalGermline(
  receptors,
  references,
  organism = "human",
  locus = "IGH",
  use_regions = FALSE,
  vonly = FALSE,
  seq = "sequence_alignment",
  id = "sequence_id",
  clone = "clone_id",
  v_call = "v_call",
  j_call = "j_call",
  j_germ_length = "j_germline_length",
  j_germ_aa_length = "j_germline_aa_length",
  amino_acid = FALSE,
  ...
)
}
\arguments{
\item{receptors}{AIRR-table containing sequences from one clone}

\item{references}{Full list of reference segments, see \link{readIMGT}}

\item{organism}{Species in \code{references} being analyzed}

\item{locus}{locus in \code{references} being analyzed}

\item{use_regions}{Return string of VDJ regions? (optional)}

\item{vonly}{Return germline of only v segment?}

\item{seq}{Column name for sequence alignment}

\item{id}{Column name for sequence ID}

\item{clone}{Column name for clone ID}

\item{v_call}{Column name for V gene segment gene call}

\item{j_call}{Column name for J gene segment gene call}

\item{j_germ_length}{Column name of J segment length within germline}

\item{j_germ_aa_length}{Column name of J segment amino acid length (if amino_acid=TRUE)}

\item{amino_acid}{Perform reconstruction on amino acid sequence (experimental)}

\item{...}{Additional arguments passed to \link{buildGermline}}
}
\value{
Tibble with reconstructed germlines
}
\description{
Determine consensus clone sequence and create germline for clone
}
\details{
Return object adds/edits following columns:
\itemize{
  \item  \code{seq}:  Sequences potentially padded  same length as germline
  \item  \code{germline_alignment}: Full length germline
  \item  \code{germline_alignment_d_mask}: Full length, D region masked
  \item  \code{vonly}:   V gene segment of germline if vonly=TRUE
  \item  \code{regions}: String of VDJ segment in position if use_regions=TRUE
}
}
\seealso{
\link{createGermlines} \link{buildGermline}, \link{stitchVDJ}
}
